/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatCitationType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatCitation {
    private final int start;
    private final int end;
    private final String text;
    private final List<String> documentIds;
    private final Optional<ChatCitationType> type;
    private final Map<String, Object> additionalProperties;

    private ChatCitation(int start, int end, String text, List<String> documentIds, Optional<ChatCitationType> type, Map<String, Object> additionalProperties) {
        this.start = start;
        this.end = end;
        this.text = text;
        this.documentIds = documentIds;
        this.type = type;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="start")
    public int getStart() {
        return this.start;
    }

    @JsonProperty(value="end")
    public int getEnd() {
        return this.end;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="document_ids")
    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    @JsonProperty(value="type")
    public Optional<ChatCitationType> getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatCitation && this.equalTo((ChatCitation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatCitation other) {
        return this.start == other.start && this.end == other.end && this.text.equals(other.text) && this.documentIds.equals(other.documentIds) && this.type.equals(other.type);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.text, this.documentIds, this.type);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StartStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StartStage,
    EndStage,
    TextStage,
    _FinalStage {
        private int start;
        private int end;
        private String text;
        private Optional<ChatCitationType> type = Optional.empty();
        private List<String> documentIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatCitation other) {
            this.start(other.getStart());
            this.end(other.getEnd());
            this.text(other.getText());
            this.documentIds(other.getDocumentIds());
            this.type(other.getType());
            return this;
        }

        @Override
        @JsonSetter(value="start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        @Override
        @JsonSetter(value="end")
        public TextStage end(int end) {
            this.end = end;
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        @Override
        public _FinalStage type(ChatCitationType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<ChatCitationType> type) {
            this.type = type;
            return this;
        }

        @Override
        public _FinalStage addAllDocumentIds(List<String> documentIds) {
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public _FinalStage addDocumentIds(String documentIds) {
            this.documentIds.add(documentIds);
            return this;
        }

        @Override
        @JsonSetter(value="document_ids", nulls=Nulls.SKIP)
        public _FinalStage documentIds(List<String> documentIds) {
            this.documentIds.clear();
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public ChatCitation build() {
            return new ChatCitation(this.start, this.end, this.text, this.documentIds, this.type, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatCitation build();

        public _FinalStage documentIds(List<String> var1);

        public _FinalStage addDocumentIds(String var1);

        public _FinalStage addAllDocumentIds(List<String> var1);

        public _FinalStage type(Optional<ChatCitationType> var1);

        public _FinalStage type(ChatCitationType var1);
    }

    public static interface TextStage {
        public _FinalStage text(@NotNull String var1);
    }

    public static interface EndStage {
        public TextStage end(int var1);
    }

    public static interface StartStage {
        public EndStage start(int var1);

        public Builder from(ChatCitation var1);
    }
}

