/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatContentDeltaEventDelta;
import com.cohere.api.types.IChatStreamEventType;
import com.cohere.api.types.LogprobItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatContentDeltaEvent
implements IChatStreamEventType {
    private final Optional<Integer> index;
    private final Optional<ChatContentDeltaEventDelta> delta;
    private final Optional<LogprobItem> logprobs;
    private final Map<String, Object> additionalProperties;

    private ChatContentDeltaEvent(Optional<Integer> index, Optional<ChatContentDeltaEventDelta> delta, Optional<LogprobItem> logprobs, Map<String, Object> additionalProperties) {
        this.index = index;
        this.delta = delta;
        this.logprobs = logprobs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="delta")
    public Optional<ChatContentDeltaEventDelta> getDelta() {
        return this.delta;
    }

    @JsonProperty(value="logprobs")
    public Optional<LogprobItem> getLogprobs() {
        return this.logprobs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatContentDeltaEvent && this.equalTo((ChatContentDeltaEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatContentDeltaEvent other) {
        return this.index.equals(other.index) && this.delta.equals(other.delta) && this.logprobs.equals(other.logprobs);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.delta, this.logprobs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> index = Optional.empty();
        private Optional<ChatContentDeltaEventDelta> delta = Optional.empty();
        private Optional<LogprobItem> logprobs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatContentDeltaEvent other) {
            this.index(other.getIndex());
            this.delta(other.getDelta());
            this.logprobs(other.getLogprobs());
            return this;
        }

        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public Builder index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        public Builder index(Integer index) {
            this.index = Optional.ofNullable(index);
            return this;
        }

        @JsonSetter(value="delta", nulls=Nulls.SKIP)
        public Builder delta(Optional<ChatContentDeltaEventDelta> delta) {
            this.delta = delta;
            return this;
        }

        public Builder delta(ChatContentDeltaEventDelta delta) {
            this.delta = Optional.ofNullable(delta);
            return this;
        }

        @JsonSetter(value="logprobs", nulls=Nulls.SKIP)
        public Builder logprobs(Optional<LogprobItem> logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public Builder logprobs(LogprobItem logprobs) {
            this.logprobs = Optional.ofNullable(logprobs);
            return this;
        }

        public ChatContentDeltaEvent build() {
            return new ChatContentDeltaEvent(this.index, this.delta, this.logprobs, this.additionalProperties);
        }
    }
}

