/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatDataMetrics {
    private final Optional<Long> numTrainTurns;
    private final Optional<Long> numEvalTurns;
    private final Optional<String> preamble;
    private final Map<String, Object> additionalProperties;

    private ChatDataMetrics(Optional<Long> numTrainTurns, Optional<Long> numEvalTurns, Optional<String> preamble, Map<String, Object> additionalProperties) {
        this.numTrainTurns = numTrainTurns;
        this.numEvalTurns = numEvalTurns;
        this.preamble = preamble;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="num_train_turns")
    public Optional<Long> getNumTrainTurns() {
        return this.numTrainTurns;
    }

    @JsonProperty(value="num_eval_turns")
    public Optional<Long> getNumEvalTurns() {
        return this.numEvalTurns;
    }

    @JsonProperty(value="preamble")
    public Optional<String> getPreamble() {
        return this.preamble;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatDataMetrics && this.equalTo((ChatDataMetrics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatDataMetrics other) {
        return this.numTrainTurns.equals(other.numTrainTurns) && this.numEvalTurns.equals(other.numEvalTurns) && this.preamble.equals(other.preamble);
    }

    public int hashCode() {
        return Objects.hash(this.numTrainTurns, this.numEvalTurns, this.preamble);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Long> numTrainTurns = Optional.empty();
        private Optional<Long> numEvalTurns = Optional.empty();
        private Optional<String> preamble = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatDataMetrics other) {
            this.numTrainTurns(other.getNumTrainTurns());
            this.numEvalTurns(other.getNumEvalTurns());
            this.preamble(other.getPreamble());
            return this;
        }

        @JsonSetter(value="num_train_turns", nulls=Nulls.SKIP)
        public Builder numTrainTurns(Optional<Long> numTrainTurns) {
            this.numTrainTurns = numTrainTurns;
            return this;
        }

        public Builder numTrainTurns(Long numTrainTurns) {
            this.numTrainTurns = Optional.ofNullable(numTrainTurns);
            return this;
        }

        @JsonSetter(value="num_eval_turns", nulls=Nulls.SKIP)
        public Builder numEvalTurns(Optional<Long> numEvalTurns) {
            this.numEvalTurns = numEvalTurns;
            return this;
        }

        public Builder numEvalTurns(Long numEvalTurns) {
            this.numEvalTurns = Optional.ofNullable(numEvalTurns);
            return this;
        }

        @JsonSetter(value="preamble", nulls=Nulls.SKIP)
        public Builder preamble(Optional<String> preamble) {
            this.preamble = preamble;
            return this;
        }

        public Builder preamble(String preamble) {
            this.preamble = Optional.ofNullable(preamble);
            return this;
        }

        public ChatDataMetrics build() {
            return new ChatDataMetrics(this.numTrainTurns, this.numEvalTurns, this.preamble, this.additionalProperties);
        }
    }
}

