/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatDocumentSource {
    private final Optional<String> id;
    private final Optional<Map<String, Object>> document;
    private final Map<String, Object> additionalProperties;

    private ChatDocumentSource(Optional<String> id, Optional<Map<String, Object>> document, Map<String, Object> additionalProperties) {
        this.id = id;
        this.document = document;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="document")
    public Optional<Map<String, Object>> getDocument() {
        return this.document;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatDocumentSource && this.equalTo((ChatDocumentSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatDocumentSource other) {
        return this.id.equals(other.id) && this.document.equals(other.document);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.document);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<Map<String, Object>> document = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatDocumentSource other) {
            this.id(other.getId());
            this.document(other.getDocument());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="document", nulls=Nulls.SKIP)
        public Builder document(Optional<Map<String, Object>> document) {
            this.document = document;
            return this;
        }

        public Builder document(Map<String, Object> document) {
            this.document = Optional.ofNullable(document);
            return this;
        }

        public ChatDocumentSource build() {
            return new ChatDocumentSource(this.id, this.document, this.additionalProperties);
        }
    }
}

