/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.CitationStartEventDelta;
import com.cohere.api.types.IChatStreamEventType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CitationStartEvent
implements IChatStreamEventType {
    private final Optional<Integer> index;
    private final Optional<CitationStartEventDelta> delta;
    private final Map<String, Object> additionalProperties;

    private CitationStartEvent(Optional<Integer> index, Optional<CitationStartEventDelta> delta, Map<String, Object> additionalProperties) {
        this.index = index;
        this.delta = delta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="delta")
    public Optional<CitationStartEventDelta> getDelta() {
        return this.delta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CitationStartEvent && this.equalTo((CitationStartEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CitationStartEvent other) {
        return this.index.equals(other.index) && this.delta.equals(other.delta);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.delta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> index = Optional.empty();
        private Optional<CitationStartEventDelta> delta = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CitationStartEvent other) {
            this.index(other.getIndex());
            this.delta(other.getDelta());
            return this;
        }

        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public Builder index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        public Builder index(Integer index) {
            this.index = Optional.ofNullable(index);
            return this;
        }

        @JsonSetter(value="delta", nulls=Nulls.SKIP)
        public Builder delta(Optional<CitationStartEventDelta> delta) {
            this.delta = delta;
            return this;
        }

        public Builder delta(CitationStartEventDelta delta) {
            this.delta = Optional.ofNullable(delta);
            return this;
        }

        public CitationStartEvent build() {
            return new CitationStartEvent(this.index, this.delta, this.additionalProperties);
        }
    }
}

