/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.ClassifyResponseClassificationsItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyResponse {
    private final String id;
    private final List<ClassifyResponseClassificationsItem> classifications;
    private final Optional<ApiMeta> meta;
    private final Map<String, Object> additionalProperties;

    private ClassifyResponse(String id, List<ClassifyResponseClassificationsItem> classifications, Optional<ApiMeta> meta, Map<String, Object> additionalProperties) {
        this.id = id;
        this.classifications = classifications;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="classifications")
    public List<ClassifyResponseClassificationsItem> getClassifications() {
        return this.classifications;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyResponse && this.equalTo((ClassifyResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClassifyResponse other) {
        return this.id.equals(other.id) && this.classifications.equals(other.classifications) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.classifications, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<ApiMeta> meta = Optional.empty();
        private List<ClassifyResponseClassificationsItem> classifications = new ArrayList<ClassifyResponseClassificationsItem>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ClassifyResponse other) {
            this.id(other.getId());
            this.classifications(other.getClassifications());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage addAllClassifications(List<ClassifyResponseClassificationsItem> classifications) {
            this.classifications.addAll(classifications);
            return this;
        }

        @Override
        public _FinalStage addClassifications(ClassifyResponseClassificationsItem classifications) {
            this.classifications.add(classifications);
            return this;
        }

        @Override
        @JsonSetter(value="classifications", nulls=Nulls.SKIP)
        public _FinalStage classifications(List<ClassifyResponseClassificationsItem> classifications) {
            this.classifications.clear();
            this.classifications.addAll(classifications);
            return this;
        }

        @Override
        public ClassifyResponse build() {
            return new ClassifyResponse(this.id, this.classifications, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ClassifyResponse build();

        public _FinalStage classifications(List<ClassifyResponseClassificationsItem> var1);

        public _FinalStage addClassifications(ClassifyResponseClassificationsItem var1);

        public _FinalStage addAllClassifications(List<ClassifyResponseClassificationsItem> var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(ClassifyResponse var1);
    }
}

