/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.FinishReason;
import com.cohere.api.types.IGenerateStreamEvent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GenerateStreamError
implements IGenerateStreamEvent {
    private final Optional<Integer> index;
    private final boolean isFinished;
    private final FinishReason finishReason;
    private final String err;
    private final Map<String, Object> additionalProperties;

    private GenerateStreamError(Optional<Integer> index, boolean isFinished, FinishReason finishReason, String err, Map<String, Object> additionalProperties) {
        this.index = index;
        this.isFinished = isFinished;
        this.finishReason = finishReason;
        this.err = err;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="is_finished")
    public boolean getIsFinished() {
        return this.isFinished;
    }

    @JsonProperty(value="finish_reason")
    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    @JsonProperty(value="err")
    public String getErr() {
        return this.err;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GenerateStreamError && this.equalTo((GenerateStreamError)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GenerateStreamError other) {
        return this.index.equals(other.index) && this.isFinished == other.isFinished && this.finishReason.equals((Object)other.finishReason) && this.err.equals(other.err);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.isFinished, this.finishReason, this.err});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IsFinishedStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IsFinishedStage,
    FinishReasonStage,
    ErrStage,
    _FinalStage {
        private boolean isFinished;
        private FinishReason finishReason;
        private String err;
        private Optional<Integer> index = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GenerateStreamError other) {
            this.index(other.getIndex());
            this.isFinished(other.getIsFinished());
            this.finishReason(other.getFinishReason());
            this.err(other.getErr());
            return this;
        }

        @Override
        @JsonSetter(value="is_finished")
        public FinishReasonStage isFinished(boolean isFinished) {
            this.isFinished = isFinished;
            return this;
        }

        @Override
        @JsonSetter(value="finish_reason")
        public ErrStage finishReason(@NotNull FinishReason finishReason) {
            this.finishReason = Objects.requireNonNull(finishReason, "finishReason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="err")
        public _FinalStage err(@NotNull String err) {
            this.err = Objects.requireNonNull(err, "err must not be null");
            return this;
        }

        @Override
        public _FinalStage index(Integer index) {
            this.index = Optional.ofNullable(index);
            return this;
        }

        @Override
        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public _FinalStage index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        @Override
        public GenerateStreamError build() {
            return new GenerateStreamError(this.index, this.isFinished, this.finishReason, this.err, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GenerateStreamError build();

        public _FinalStage index(Optional<Integer> var1);

        public _FinalStage index(Integer var1);
    }

    public static interface ErrStage {
        public _FinalStage err(@NotNull String var1);
    }

    public static interface FinishReasonStage {
        public ErrStage finishReason(@NotNull FinishReason var1);
    }

    public static interface IsFinishedStage {
        public FinishReasonStage isFinished(boolean var1);

        public Builder from(GenerateStreamError var1);
    }
}

