/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ImageUrlDetail;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImageUrl {
    private final String url;
    private final Optional<ImageUrlDetail> detail;
    private final Map<String, Object> additionalProperties;

    private ImageUrl(String url, Optional<ImageUrlDetail> detail, Map<String, Object> additionalProperties) {
        this.url = url;
        this.detail = detail;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="detail")
    public Optional<ImageUrlDetail> getDetail() {
        return this.detail;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImageUrl && this.equalTo((ImageUrl)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImageUrl other) {
        return this.url.equals(other.url) && this.detail.equals(other.detail);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.detail);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    _FinalStage {
        private String url;
        private Optional<ImageUrlDetail> detail = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImageUrl other) {
            this.url(other.getUrl());
            this.detail(other.getDetail());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage detail(ImageUrlDetail detail) {
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        @Override
        @JsonSetter(value="detail", nulls=Nulls.SKIP)
        public _FinalStage detail(Optional<ImageUrlDetail> detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public ImageUrl build() {
            return new ImageUrl(this.url, this.detail, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImageUrl build();

        public _FinalStage detail(Optional<ImageUrlDetail> var1);

        public _FinalStage detail(ImageUrlDetail var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);

        public Builder from(ImageUrl var1);
    }
}

