/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LabelMetric {
    private final Optional<Long> totalExamples;
    private final Optional<String> label;
    private final Optional<List<String>> samples;
    private final Map<String, Object> additionalProperties;

    private LabelMetric(Optional<Long> totalExamples, Optional<String> label, Optional<List<String>> samples, Map<String, Object> additionalProperties) {
        this.totalExamples = totalExamples;
        this.label = label;
        this.samples = samples;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="total_examples")
    public Optional<Long> getTotalExamples() {
        return this.totalExamples;
    }

    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return this.label;
    }

    @JsonProperty(value="samples")
    public Optional<List<String>> getSamples() {
        return this.samples;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LabelMetric && this.equalTo((LabelMetric)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LabelMetric other) {
        return this.totalExamples.equals(other.totalExamples) && this.label.equals(other.label) && this.samples.equals(other.samples);
    }

    public int hashCode() {
        return Objects.hash(this.totalExamples, this.label, this.samples);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Long> totalExamples = Optional.empty();
        private Optional<String> label = Optional.empty();
        private Optional<List<String>> samples = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LabelMetric other) {
            this.totalExamples(other.getTotalExamples());
            this.label(other.getLabel());
            this.samples(other.getSamples());
            return this;
        }

        @JsonSetter(value="total_examples", nulls=Nulls.SKIP)
        public Builder totalExamples(Optional<Long> totalExamples) {
            this.totalExamples = totalExamples;
            return this;
        }

        public Builder totalExamples(Long totalExamples) {
            this.totalExamples = Optional.ofNullable(totalExamples);
            return this;
        }

        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public Builder label(Optional<String> label) {
            this.label = label;
            return this;
        }

        public Builder label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        @JsonSetter(value="samples", nulls=Nulls.SKIP)
        public Builder samples(Optional<List<String>> samples) {
            this.samples = samples;
            return this;
        }

        public Builder samples(List<String> samples) {
            this.samples = Optional.ofNullable(samples);
            return this;
        }

        public LabelMetric build() {
            return new LabelMetric(this.totalExamples, this.label, this.samples, this.additionalProperties);
        }
    }
}

