/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.Connector;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListConnectorsResponse {
    private final List<Connector> connectors;
    private final Optional<Double> totalCount;
    private final Map<String, Object> additionalProperties;

    private ListConnectorsResponse(List<Connector> connectors, Optional<Double> totalCount, Map<String, Object> additionalProperties) {
        this.connectors = connectors;
        this.totalCount = totalCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="connectors")
    public List<Connector> getConnectors() {
        return this.connectors;
    }

    @JsonProperty(value="total_count")
    public Optional<Double> getTotalCount() {
        return this.totalCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListConnectorsResponse && this.equalTo((ListConnectorsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListConnectorsResponse other) {
        return this.connectors.equals(other.connectors) && this.totalCount.equals(other.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.connectors, this.totalCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Connector> connectors = new ArrayList<Connector>();
        private Optional<Double> totalCount = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListConnectorsResponse other) {
            this.connectors(other.getConnectors());
            this.totalCount(other.getTotalCount());
            return this;
        }

        @JsonSetter(value="connectors", nulls=Nulls.SKIP)
        public Builder connectors(List<Connector> connectors) {
            this.connectors.clear();
            this.connectors.addAll(connectors);
            return this;
        }

        public Builder addConnectors(Connector connectors) {
            this.connectors.add(connectors);
            return this;
        }

        public Builder addAllConnectors(List<Connector> connectors) {
            this.connectors.addAll(connectors);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Double> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Double totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        public ListConnectorsResponse build() {
            return new ListConnectorsResponse(this.connectors, this.totalCount, this.additionalProperties);
        }
    }
}

