/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.GetModelResponse;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListModelsResponse {
    private final List<GetModelResponse> models;
    private final Optional<String> nextPageToken;
    private final Map<String, Object> additionalProperties;

    private ListModelsResponse(List<GetModelResponse> models, Optional<String> nextPageToken, Map<String, Object> additionalProperties) {
        this.models = models;
        this.nextPageToken = nextPageToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="models")
    public List<GetModelResponse> getModels() {
        return this.models;
    }

    @JsonProperty(value="next_page_token")
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListModelsResponse && this.equalTo((ListModelsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListModelsResponse other) {
        return this.models.equals(other.models) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.models, this.nextPageToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<GetModelResponse> models = new ArrayList<GetModelResponse>();
        private Optional<String> nextPageToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListModelsResponse other) {
            this.models(other.getModels());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="models", nulls=Nulls.SKIP)
        public Builder models(List<GetModelResponse> models) {
            this.models.clear();
            this.models.addAll(models);
            return this;
        }

        public Builder addModels(GetModelResponse models) {
            this.models.add(models);
            return this;
        }

        public Builder addAllModels(List<GetModelResponse> models) {
            this.models.addAll(models);
            return this;
        }

        @JsonSetter(value="next_page_token", nulls=Nulls.SKIP)
        public Builder nextPageToken(Optional<String> nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = Optional.ofNullable(nextPageToken);
            return this;
        }

        public ListModelsResponse build() {
            return new ListModelsResponse(this.models, this.nextPageToken, this.additionalProperties);
        }
    }
}

