/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.ChatMessage;
import com.cohere.api.types.ChatToolMessage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class Message {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Message(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static Message chatbot(ChatMessage value) {
        return new Message(new ChatbotValue(value));
    }

    public static Message system(ChatMessage value) {
        return new Message(new SystemValue(value));
    }

    public static Message user(ChatMessage value) {
        return new Message(new UserValue(value));
    }

    public static Message tool(ChatToolMessage value) {
        return new Message(new ToolValue(value));
    }

    public boolean isChatbot() {
        return this.value instanceof ChatbotValue;
    }

    public boolean isSystem() {
        return this.value instanceof SystemValue;
    }

    public boolean isUser() {
        return this.value instanceof UserValue;
    }

    public boolean isTool() {
        return this.value instanceof ToolValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ChatMessage> getChatbot() {
        if (this.isChatbot()) {
            return Optional.of(((ChatbotValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatMessage> getSystem() {
        if (this.isSystem()) {
            return Optional.of(((SystemValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatMessage> getUser() {
        if (this.isUser()) {
            return Optional.of(((UserValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolMessage> getTool() {
        if (this.isTool()) {
            return Optional.of(((ToolValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"role"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "Message{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="TOOL")
    @JsonIgnoreProperties(value={"role"})
    private static final class ToolValue
    implements Value {
        @JsonUnwrapped
        private ChatToolMessage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolValue() {
        }

        private ToolValue(ChatToolMessage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTool(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolValue && this.equalTo((ToolValue)other);
        }

        private boolean equalTo(ToolValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Message{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="USER")
    @JsonIgnoreProperties(value={"role"})
    private static final class UserValue
    implements Value {
        @JsonUnwrapped
        private ChatMessage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UserValue() {
        }

        private UserValue(ChatMessage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitUser(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UserValue && this.equalTo((UserValue)other);
        }

        private boolean equalTo(UserValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Message{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="SYSTEM")
    @JsonIgnoreProperties(value={"role"})
    private static final class SystemValue
    implements Value {
        @JsonUnwrapped
        private ChatMessage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SystemValue() {
        }

        private SystemValue(ChatMessage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSystem(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SystemValue && this.equalTo((SystemValue)other);
        }

        private boolean equalTo(SystemValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Message{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="CHATBOT")
    @JsonIgnoreProperties(value={"role"})
    private static final class ChatbotValue
    implements Value {
        @JsonUnwrapped
        private ChatMessage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ChatbotValue() {
        }

        private ChatbotValue(ChatMessage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitChatbot(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ChatbotValue && this.equalTo((ChatbotValue)other);
        }

        private boolean equalTo(ChatbotValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Message{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="role", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ChatbotValue.class), @JsonSubTypes.Type(value=SystemValue.class), @JsonSubTypes.Type(value=UserValue.class), @JsonSubTypes.Type(value=ToolValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitChatbot(ChatMessage var1);

        public T visitSystem(ChatMessage var1);

        public T visitUser(ChatMessage var1);

        public T visitTool(ChatToolMessage var1);

        public T _visitUnknown(Object var1);
    }
}

