/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolMessageV2Content;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ToolMessageV2 {
    private final String toolCallId;
    private final ToolMessageV2Content content;
    private final Map<String, Object> additionalProperties;

    private ToolMessageV2(String toolCallId, ToolMessageV2Content content, Map<String, Object> additionalProperties) {
        this.toolCallId = toolCallId;
        this.content = content;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="tool_call_id")
    public String getToolCallId() {
        return this.toolCallId;
    }

    @JsonProperty(value="content")
    public ToolMessageV2Content getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolMessageV2 && this.equalTo((ToolMessageV2)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolMessageV2 other) {
        return this.toolCallId.equals(other.toolCallId) && this.content.equals(other.content);
    }

    public int hashCode() {
        return Objects.hash(this.toolCallId, this.content);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ToolCallIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ToolCallIdStage,
    ContentStage,
    _FinalStage {
        private String toolCallId;
        private ToolMessageV2Content content;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ToolMessageV2 other) {
            this.toolCallId(other.getToolCallId());
            this.content(other.getContent());
            return this;
        }

        @Override
        @JsonSetter(value="tool_call_id")
        public ContentStage toolCallId(@NotNull String toolCallId) {
            this.toolCallId = Objects.requireNonNull(toolCallId, "toolCallId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(@NotNull ToolMessageV2Content content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @Override
        public ToolMessageV2 build() {
            return new ToolMessageV2(this.toolCallId, this.content, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ToolMessageV2 build();
    }

    public static interface ContentStage {
        public _FinalStage content(@NotNull ToolMessageV2Content var1);
    }

    public static interface ToolCallIdStage {
        public ContentStage toolCallId(@NotNull String var1);

        public Builder from(ToolMessageV2 var1);
    }
}

