/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ToolV2Function {
    private final String name;
    private final Optional<String> description;
    private final Map<String, Object> parameters;
    private final Map<String, Object> additionalProperties;

    private ToolV2Function(String name, Optional<String> description, Map<String, Object> parameters, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="parameters")
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolV2Function && this.equalTo((ToolV2Function)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolV2Function other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.parameters);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ToolV2Function other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.parameters(other.getParameters());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage parameters(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllParameters(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        @Override
        @JsonSetter(value="parameters", nulls=Nulls.SKIP)
        public _FinalStage parameters(Map<String, Object> parameters) {
            this.parameters.clear();
            this.parameters.putAll(parameters);
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public ToolV2Function build() {
            return new ToolV2Function(this.name, this.description, this.parameters, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ToolV2Function build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage parameters(Map<String, Object> var1);

        public _FinalStage putAllParameters(Map<String, Object> var1);

        public _FinalStage parameters(String var1, Object var2);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(ToolV2Function var1);
    }
}

