/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UsageBilledUnits {
    private final Optional<Double> inputTokens;
    private final Optional<Double> outputTokens;
    private final Optional<Double> searchUnits;
    private final Optional<Double> classifications;
    private final Map<String, Object> additionalProperties;

    private UsageBilledUnits(Optional<Double> inputTokens, Optional<Double> outputTokens, Optional<Double> searchUnits, Optional<Double> classifications, Map<String, Object> additionalProperties) {
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.searchUnits = searchUnits;
        this.classifications = classifications;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="input_tokens")
    public Optional<Double> getInputTokens() {
        return this.inputTokens;
    }

    @JsonProperty(value="output_tokens")
    public Optional<Double> getOutputTokens() {
        return this.outputTokens;
    }

    @JsonProperty(value="search_units")
    public Optional<Double> getSearchUnits() {
        return this.searchUnits;
    }

    @JsonProperty(value="classifications")
    public Optional<Double> getClassifications() {
        return this.classifications;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UsageBilledUnits && this.equalTo((UsageBilledUnits)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UsageBilledUnits other) {
        return this.inputTokens.equals(other.inputTokens) && this.outputTokens.equals(other.outputTokens) && this.searchUnits.equals(other.searchUnits) && this.classifications.equals(other.classifications);
    }

    public int hashCode() {
        return Objects.hash(this.inputTokens, this.outputTokens, this.searchUnits, this.classifications);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> inputTokens = Optional.empty();
        private Optional<Double> outputTokens = Optional.empty();
        private Optional<Double> searchUnits = Optional.empty();
        private Optional<Double> classifications = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UsageBilledUnits other) {
            this.inputTokens(other.getInputTokens());
            this.outputTokens(other.getOutputTokens());
            this.searchUnits(other.getSearchUnits());
            this.classifications(other.getClassifications());
            return this;
        }

        @JsonSetter(value="input_tokens", nulls=Nulls.SKIP)
        public Builder inputTokens(Optional<Double> inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        public Builder inputTokens(Double inputTokens) {
            this.inputTokens = Optional.ofNullable(inputTokens);
            return this;
        }

        @JsonSetter(value="output_tokens", nulls=Nulls.SKIP)
        public Builder outputTokens(Optional<Double> outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        public Builder outputTokens(Double outputTokens) {
            this.outputTokens = Optional.ofNullable(outputTokens);
            return this;
        }

        @JsonSetter(value="search_units", nulls=Nulls.SKIP)
        public Builder searchUnits(Optional<Double> searchUnits) {
            this.searchUnits = searchUnits;
            return this;
        }

        public Builder searchUnits(Double searchUnits) {
            this.searchUnits = Optional.ofNullable(searchUnits);
            return this;
        }

        @JsonSetter(value="classifications", nulls=Nulls.SKIP)
        public Builder classifications(Optional<Double> classifications) {
            this.classifications = classifications;
            return this;
        }

        public Builder classifications(Double classifications) {
            this.classifications = Optional.ofNullable(classifications);
            return this;
        }

        public UsageBilledUnits build() {
            return new UsageBilledUnits(this.inputTokens, this.outputTokens, this.searchUnits, this.classifications, this.additionalProperties);
        }
    }
}

