/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api;

import com.cohere.api.AsyncCohereBuilder;
import com.cohere.api.AsyncRawCohere;
import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.core.Suppliers;
import com.cohere.api.requests.ChatRequest;
import com.cohere.api.requests.ChatStreamRequest;
import com.cohere.api.requests.ClassifyRequest;
import com.cohere.api.requests.DetokenizeRequest;
import com.cohere.api.requests.EmbedRequest;
import com.cohere.api.requests.GenerateRequest;
import com.cohere.api.requests.GenerateStreamRequest;
import com.cohere.api.requests.RerankRequest;
import com.cohere.api.requests.SummarizeRequest;
import com.cohere.api.requests.TokenizeRequest;
import com.cohere.api.resources.batches.AsyncBatchesClient;
import com.cohere.api.resources.connectors.AsyncConnectorsClient;
import com.cohere.api.resources.datasets.AsyncDatasetsClient;
import com.cohere.api.resources.embedjobs.AsyncEmbedJobsClient;
import com.cohere.api.resources.finetuning.AsyncFinetuningClient;
import com.cohere.api.resources.models.AsyncModelsClient;
import com.cohere.api.resources.v2.AsyncV2Client;
import com.cohere.api.types.CheckApiKeyResponse;
import com.cohere.api.types.ClassifyResponse;
import com.cohere.api.types.DetokenizeResponse;
import com.cohere.api.types.EmbedResponse;
import com.cohere.api.types.GenerateStreamedResponse;
import com.cohere.api.types.Generation;
import com.cohere.api.types.NonStreamedChatResponse;
import com.cohere.api.types.RerankResponse;
import com.cohere.api.types.StreamedChatResponse;
import com.cohere.api.types.SummarizeResponse;
import com.cohere.api.types.TokenizeResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncCohere {
    protected final ClientOptions clientOptions;
    private final AsyncRawCohere rawClient;
    protected final Supplier<AsyncV2Client> v2Client;
    protected final Supplier<AsyncBatchesClient> batchesClient;
    protected final Supplier<AsyncEmbedJobsClient> embedJobsClient;
    protected final Supplier<AsyncDatasetsClient> datasetsClient;
    protected final Supplier<AsyncConnectorsClient> connectorsClient;
    protected final Supplier<AsyncModelsClient> modelsClient;
    protected final Supplier<AsyncFinetuningClient> finetuningClient;

    public AsyncCohere(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCohere(clientOptions);
        this.v2Client = Suppliers.memoize(() -> new AsyncV2Client(clientOptions));
        this.batchesClient = Suppliers.memoize(() -> new AsyncBatchesClient(clientOptions));
        this.embedJobsClient = Suppliers.memoize(() -> new AsyncEmbedJobsClient(clientOptions));
        this.datasetsClient = Suppliers.memoize(() -> new AsyncDatasetsClient(clientOptions));
        this.connectorsClient = Suppliers.memoize(() -> new AsyncConnectorsClient(clientOptions));
        this.modelsClient = Suppliers.memoize(() -> new AsyncModelsClient(clientOptions));
        this.finetuningClient = Suppliers.memoize(() -> new AsyncFinetuningClient(clientOptions));
    }

    public AsyncRawCohere withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Iterable<StreamedChatResponse>> chatStream(ChatStreamRequest request) {
        return this.rawClient.chatStream(request).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<Iterable<StreamedChatResponse>> chatStream(ChatStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.chatStream(request, requestOptions).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<NonStreamedChatResponse> chat(ChatRequest request) {
        return this.rawClient.chat(request).thenApply(response -> (NonStreamedChatResponse)response.body());
    }

    public CompletableFuture<NonStreamedChatResponse> chat(ChatRequest request, RequestOptions requestOptions) {
        return this.rawClient.chat(request, requestOptions).thenApply(response -> (NonStreamedChatResponse)response.body());
    }

    public CompletableFuture<Iterable<GenerateStreamedResponse>> generateStream(GenerateStreamRequest request) {
        return this.rawClient.generateStream(request).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<Iterable<GenerateStreamedResponse>> generateStream(GenerateStreamRequest request, RequestOptions requestOptions) {
        return this.rawClient.generateStream(request, requestOptions).thenApply(response -> (Iterable)response.body());
    }

    public CompletableFuture<Generation> generate(GenerateRequest request) {
        return this.rawClient.generate(request).thenApply(response -> (Generation)response.body());
    }

    public CompletableFuture<Generation> generate(GenerateRequest request, RequestOptions requestOptions) {
        return this.rawClient.generate(request, requestOptions).thenApply(response -> (Generation)response.body());
    }

    public CompletableFuture<EmbedResponse> embed() {
        return this.rawClient.embed().thenApply(response -> (EmbedResponse)response.body());
    }

    public CompletableFuture<EmbedResponse> embed(EmbedRequest request) {
        return this.rawClient.embed(request).thenApply(response -> (EmbedResponse)response.body());
    }

    public CompletableFuture<EmbedResponse> embed(EmbedRequest request, RequestOptions requestOptions) {
        return this.rawClient.embed(request, requestOptions).thenApply(response -> (EmbedResponse)response.body());
    }

    public CompletableFuture<RerankResponse> rerank(RerankRequest request) {
        return this.rawClient.rerank(request).thenApply(response -> (RerankResponse)response.body());
    }

    public CompletableFuture<RerankResponse> rerank(RerankRequest request, RequestOptions requestOptions) {
        return this.rawClient.rerank(request, requestOptions).thenApply(response -> (RerankResponse)response.body());
    }

    public CompletableFuture<ClassifyResponse> classify(ClassifyRequest request) {
        return this.rawClient.classify(request).thenApply(response -> (ClassifyResponse)response.body());
    }

    public CompletableFuture<ClassifyResponse> classify(ClassifyRequest request, RequestOptions requestOptions) {
        return this.rawClient.classify(request, requestOptions).thenApply(response -> (ClassifyResponse)response.body());
    }

    public CompletableFuture<SummarizeResponse> summarize(SummarizeRequest request) {
        return this.rawClient.summarize(request).thenApply(response -> (SummarizeResponse)response.body());
    }

    public CompletableFuture<SummarizeResponse> summarize(SummarizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.summarize(request, requestOptions).thenApply(response -> (SummarizeResponse)response.body());
    }

    public CompletableFuture<TokenizeResponse> tokenize(TokenizeRequest request) {
        return this.rawClient.tokenize(request).thenApply(response -> (TokenizeResponse)response.body());
    }

    public CompletableFuture<TokenizeResponse> tokenize(TokenizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.tokenize(request, requestOptions).thenApply(response -> (TokenizeResponse)response.body());
    }

    public CompletableFuture<DetokenizeResponse> detokenize(DetokenizeRequest request) {
        return this.rawClient.detokenize(request).thenApply(response -> (DetokenizeResponse)response.body());
    }

    public CompletableFuture<DetokenizeResponse> detokenize(DetokenizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.detokenize(request, requestOptions).thenApply(response -> (DetokenizeResponse)response.body());
    }

    public CompletableFuture<CheckApiKeyResponse> checkApiKey() {
        return this.rawClient.checkApiKey().thenApply(response -> (CheckApiKeyResponse)response.body());
    }

    public CompletableFuture<CheckApiKeyResponse> checkApiKey(RequestOptions requestOptions) {
        return this.rawClient.checkApiKey(requestOptions).thenApply(response -> (CheckApiKeyResponse)response.body());
    }

    public AsyncV2Client v2() {
        return this.v2Client.get();
    }

    public AsyncBatchesClient batches() {
        return this.batchesClient.get();
    }

    public AsyncEmbedJobsClient embedJobs() {
        return this.embedJobsClient.get();
    }

    public AsyncDatasetsClient datasets() {
        return this.datasetsClient.get();
    }

    public AsyncConnectorsClient connectors() {
        return this.connectorsClient.get();
    }

    public AsyncModelsClient models() {
        return this.modelsClient.get();
    }

    public AsyncFinetuningClient finetuning() {
        return this.finetuningClient.get();
    }

    public static AsyncCohereBuilder builder() {
        return new AsyncCohereBuilder();
    }
}

