/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

class DateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    private static final SimpleModule MODULE = new SimpleModule().addDeserializer(OffsetDateTime.class, (JsonDeserializer)new DateTimeDeserializer());

    DateTimeDeserializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    public OffsetDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(parser.getValueAsLong()), ZoneOffset.UTC);
        }
        TemporalAccessor temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(parser.getValueAsString(), OffsetDateTime::from, LocalDateTime::from);
        if (temporal.query(TemporalQueries.offset()) == null) {
            return LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC);
        }
        return OffsetDateTime.from(temporal);
    }
}

