/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.batches;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.batches.AsyncRawBatchesClient;
import com.cohere.api.resources.batches.requests.BatchesListBatchesRequest;
import com.cohere.api.resources.batches.types.Batch;
import com.cohere.api.resources.batches.types.CreateBatchResponse;
import com.cohere.api.resources.batches.types.GetBatchResponse;
import com.cohere.api.resources.batches.types.ListBatchesResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AsyncBatchesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBatchesClient rawClient;

    public AsyncBatchesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBatchesClient(clientOptions);
    }

    public AsyncRawBatchesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListBatchesResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListBatchesResponse)response.body());
    }

    public CompletableFuture<ListBatchesResponse> list(BatchesListBatchesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (ListBatchesResponse)response.body());
    }

    public CompletableFuture<ListBatchesResponse> list(BatchesListBatchesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (ListBatchesResponse)response.body());
    }

    public CompletableFuture<CreateBatchResponse> create(Batch request) {
        return this.rawClient.create(request).thenApply(response -> (CreateBatchResponse)response.body());
    }

    public CompletableFuture<CreateBatchResponse> create(Batch request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateBatchResponse)response.body());
    }

    public CompletableFuture<GetBatchResponse> retrieve(String id) {
        return this.rawClient.retrieve(id).thenApply(response -> (GetBatchResponse)response.body());
    }

    public CompletableFuture<GetBatchResponse> retrieve(String id, RequestOptions requestOptions) {
        return this.rawClient.retrieve(id, requestOptions).thenApply(response -> (GetBatchResponse)response.body());
    }

    public CompletableFuture<Map<String, Object>> cancel(String id) {
        return this.rawClient.cancel(id).thenApply(response -> (Map)response.body());
    }

    public CompletableFuture<Map<String, Object>> cancel(String id, RequestOptions requestOptions) {
        return this.rawClient.cancel(id, requestOptions).thenApply(response -> (Map)response.body());
    }
}

