/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.batches;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.batches.RawBatchesClient;
import com.cohere.api.resources.batches.requests.BatchesListBatchesRequest;
import com.cohere.api.resources.batches.types.Batch;
import com.cohere.api.resources.batches.types.CreateBatchResponse;
import com.cohere.api.resources.batches.types.GetBatchResponse;
import com.cohere.api.resources.batches.types.ListBatchesResponse;
import java.util.Map;

public class BatchesClient {
    protected final ClientOptions clientOptions;
    private final RawBatchesClient rawClient;

    public BatchesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawBatchesClient(clientOptions);
    }

    public RawBatchesClient withRawResponse() {
        return this.rawClient;
    }

    public ListBatchesResponse list() {
        return this.rawClient.list().body();
    }

    public ListBatchesResponse list(BatchesListBatchesRequest request) {
        return this.rawClient.list(request).body();
    }

    public ListBatchesResponse list(BatchesListBatchesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateBatchResponse create(Batch request) {
        return this.rawClient.create(request).body();
    }

    public CreateBatchResponse create(Batch request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetBatchResponse retrieve(String id) {
        return this.rawClient.retrieve(id).body();
    }

    public GetBatchResponse retrieve(String id, RequestOptions requestOptions) {
        return this.rawClient.retrieve(id, requestOptions).body();
    }

    public Map<String, Object> cancel(String id) {
        return this.rawClient.cancel(id).body();
    }

    public Map<String, Object> cancel(String id, RequestOptions requestOptions) {
        return this.rawClient.cancel(id, requestOptions).body();
    }
}

