/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.batches.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.batches.types.BatchStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Batch {
    private final Optional<String> id;
    private final String name;
    private final Optional<String> creatorId;
    private final Optional<String> orgId;
    private final Optional<BatchStatus> status;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> updatedAt;
    private final String inputDatasetId;
    private final Optional<String> outputDatasetId;
    private final Optional<String> inputTokens;
    private final Optional<String> outputTokens;
    private final String model;
    private final Optional<Integer> numRecords;
    private final Optional<Integer> numSuccessfulRecords;
    private final Optional<Integer> numFailedRecords;
    private final Optional<String> statusReason;
    private final Map<String, Object> additionalProperties;

    private Batch(Optional<String> id, String name, Optional<String> creatorId, Optional<String> orgId, Optional<BatchStatus> status, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, String inputDatasetId, Optional<String> outputDatasetId, Optional<String> inputTokens, Optional<String> outputTokens, String model, Optional<Integer> numRecords, Optional<Integer> numSuccessfulRecords, Optional<Integer> numFailedRecords, Optional<String> statusReason, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.creatorId = creatorId;
        this.orgId = orgId;
        this.status = status;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.inputDatasetId = inputDatasetId;
        this.outputDatasetId = outputDatasetId;
        this.inputTokens = inputTokens;
        this.outputTokens = outputTokens;
        this.model = model;
        this.numRecords = numRecords;
        this.numSuccessfulRecords = numSuccessfulRecords;
        this.numFailedRecords = numFailedRecords;
        this.statusReason = statusReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="creator_id")
    public Optional<String> getCreatorId() {
        return this.creatorId;
    }

    @JsonProperty(value="org_id")
    public Optional<String> getOrgId() {
        return this.orgId;
    }

    @JsonProperty(value="status")
    public Optional<BatchStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="input_dataset_id")
    public String getInputDatasetId() {
        return this.inputDatasetId;
    }

    @JsonProperty(value="output_dataset_id")
    public Optional<String> getOutputDatasetId() {
        return this.outputDatasetId;
    }

    @JsonProperty(value="input_tokens")
    public Optional<String> getInputTokens() {
        return this.inputTokens;
    }

    @JsonProperty(value="output_tokens")
    public Optional<String> getOutputTokens() {
        return this.outputTokens;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="num_records")
    public Optional<Integer> getNumRecords() {
        return this.numRecords;
    }

    @JsonProperty(value="num_successful_records")
    public Optional<Integer> getNumSuccessfulRecords() {
        return this.numSuccessfulRecords;
    }

    @JsonProperty(value="num_failed_records")
    public Optional<Integer> getNumFailedRecords() {
        return this.numFailedRecords;
    }

    @JsonProperty(value="status_reason")
    public Optional<String> getStatusReason() {
        return this.statusReason;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Batch && this.equalTo((Batch)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Batch other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.creatorId.equals(other.creatorId) && this.orgId.equals(other.orgId) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.inputDatasetId.equals(other.inputDatasetId) && this.outputDatasetId.equals(other.outputDatasetId) && this.inputTokens.equals(other.inputTokens) && this.outputTokens.equals(other.outputTokens) && this.model.equals(other.model) && this.numRecords.equals(other.numRecords) && this.numSuccessfulRecords.equals(other.numSuccessfulRecords) && this.numFailedRecords.equals(other.numFailedRecords) && this.statusReason.equals(other.statusReason);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.creatorId, this.orgId, this.status, this.createdAt, this.updatedAt, this.inputDatasetId, this.outputDatasetId, this.inputTokens, this.outputTokens, this.model, this.numRecords, this.numSuccessfulRecords, this.numFailedRecords, this.statusReason);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    InputDatasetIdStage,
    ModelStage,
    _FinalStage {
        private String name;
        private String inputDatasetId;
        private String model;
        private Optional<String> statusReason = Optional.empty();
        private Optional<Integer> numFailedRecords = Optional.empty();
        private Optional<Integer> numSuccessfulRecords = Optional.empty();
        private Optional<Integer> numRecords = Optional.empty();
        private Optional<String> outputTokens = Optional.empty();
        private Optional<String> inputTokens = Optional.empty();
        private Optional<String> outputDatasetId = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<BatchStatus> status = Optional.empty();
        private Optional<String> orgId = Optional.empty();
        private Optional<String> creatorId = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Batch other) {
            this.id(other.getId());
            this.name(other.getName());
            this.creatorId(other.getCreatorId());
            this.orgId(other.getOrgId());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.inputDatasetId(other.getInputDatasetId());
            this.outputDatasetId(other.getOutputDatasetId());
            this.inputTokens(other.getInputTokens());
            this.outputTokens(other.getOutputTokens());
            this.model(other.getModel());
            this.numRecords(other.getNumRecords());
            this.numSuccessfulRecords(other.getNumSuccessfulRecords());
            this.numFailedRecords(other.getNumFailedRecords());
            this.statusReason(other.getStatusReason());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public InputDatasetIdStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="input_dataset_id")
        public ModelStage inputDatasetId(@NotNull String inputDatasetId) {
            this.inputDatasetId = Objects.requireNonNull(inputDatasetId, "inputDatasetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(@NotNull String model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        public _FinalStage statusReason(String statusReason) {
            this.statusReason = Optional.ofNullable(statusReason);
            return this;
        }

        @Override
        @JsonSetter(value="status_reason", nulls=Nulls.SKIP)
        public _FinalStage statusReason(Optional<String> statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public _FinalStage numFailedRecords(Integer numFailedRecords) {
            this.numFailedRecords = Optional.ofNullable(numFailedRecords);
            return this;
        }

        @Override
        @JsonSetter(value="num_failed_records", nulls=Nulls.SKIP)
        public _FinalStage numFailedRecords(Optional<Integer> numFailedRecords) {
            this.numFailedRecords = numFailedRecords;
            return this;
        }

        @Override
        public _FinalStage numSuccessfulRecords(Integer numSuccessfulRecords) {
            this.numSuccessfulRecords = Optional.ofNullable(numSuccessfulRecords);
            return this;
        }

        @Override
        @JsonSetter(value="num_successful_records", nulls=Nulls.SKIP)
        public _FinalStage numSuccessfulRecords(Optional<Integer> numSuccessfulRecords) {
            this.numSuccessfulRecords = numSuccessfulRecords;
            return this;
        }

        @Override
        public _FinalStage numRecords(Integer numRecords) {
            this.numRecords = Optional.ofNullable(numRecords);
            return this;
        }

        @Override
        @JsonSetter(value="num_records", nulls=Nulls.SKIP)
        public _FinalStage numRecords(Optional<Integer> numRecords) {
            this.numRecords = numRecords;
            return this;
        }

        @Override
        public _FinalStage outputTokens(String outputTokens) {
            this.outputTokens = Optional.ofNullable(outputTokens);
            return this;
        }

        @Override
        @JsonSetter(value="output_tokens", nulls=Nulls.SKIP)
        public _FinalStage outputTokens(Optional<String> outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        @Override
        public _FinalStage inputTokens(String inputTokens) {
            this.inputTokens = Optional.ofNullable(inputTokens);
            return this;
        }

        @Override
        @JsonSetter(value="input_tokens", nulls=Nulls.SKIP)
        public _FinalStage inputTokens(Optional<String> inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        @Override
        public _FinalStage outputDatasetId(String outputDatasetId) {
            this.outputDatasetId = Optional.ofNullable(outputDatasetId);
            return this;
        }

        @Override
        @JsonSetter(value="output_dataset_id", nulls=Nulls.SKIP)
        public _FinalStage outputDatasetId(Optional<String> outputDatasetId) {
            this.outputDatasetId = outputDatasetId;
            return this;
        }

        @Override
        public _FinalStage updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage status(BatchStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<BatchStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage orgId(String orgId) {
            this.orgId = Optional.ofNullable(orgId);
            return this;
        }

        @Override
        @JsonSetter(value="org_id", nulls=Nulls.SKIP)
        public _FinalStage orgId(Optional<String> orgId) {
            this.orgId = orgId;
            return this;
        }

        @Override
        public _FinalStage creatorId(String creatorId) {
            this.creatorId = Optional.ofNullable(creatorId);
            return this;
        }

        @Override
        @JsonSetter(value="creator_id", nulls=Nulls.SKIP)
        public _FinalStage creatorId(Optional<String> creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Batch build() {
            return new Batch(this.id, this.name, this.creatorId, this.orgId, this.status, this.createdAt, this.updatedAt, this.inputDatasetId, this.outputDatasetId, this.inputTokens, this.outputTokens, this.model, this.numRecords, this.numSuccessfulRecords, this.numFailedRecords, this.statusReason, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Batch build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage creatorId(Optional<String> var1);

        public _FinalStage creatorId(String var1);

        public _FinalStage orgId(Optional<String> var1);

        public _FinalStage orgId(String var1);

        public _FinalStage status(Optional<BatchStatus> var1);

        public _FinalStage status(BatchStatus var1);

        public _FinalStage createdAt(Optional<OffsetDateTime> var1);

        public _FinalStage createdAt(OffsetDateTime var1);

        public _FinalStage updatedAt(Optional<OffsetDateTime> var1);

        public _FinalStage updatedAt(OffsetDateTime var1);

        public _FinalStage outputDatasetId(Optional<String> var1);

        public _FinalStage outputDatasetId(String var1);

        public _FinalStage inputTokens(Optional<String> var1);

        public _FinalStage inputTokens(String var1);

        public _FinalStage outputTokens(Optional<String> var1);

        public _FinalStage outputTokens(String var1);

        public _FinalStage numRecords(Optional<Integer> var1);

        public _FinalStage numRecords(Integer var1);

        public _FinalStage numSuccessfulRecords(Optional<Integer> var1);

        public _FinalStage numSuccessfulRecords(Integer var1);

        public _FinalStage numFailedRecords(Optional<Integer> var1);

        public _FinalStage numFailedRecords(Integer var1);

        public _FinalStage statusReason(Optional<String> var1);

        public _FinalStage statusReason(String var1);
    }

    public static interface ModelStage {
        public _FinalStage model(@NotNull String var1);
    }

    public static interface InputDatasetIdStage {
        public ModelStage inputDatasetId(@NotNull String var1);
    }

    public static interface NameStage {
        public InputDatasetIdStage name(@NotNull String var1);

        public Builder from(Batch var1);
    }
}

