/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.batches.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.batches.types.Batch;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListBatchesResponse {
    private final Optional<List<Batch>> batches;
    private final Optional<String> nextPageToken;
    private final Map<String, Object> additionalProperties;

    private ListBatchesResponse(Optional<List<Batch>> batches, Optional<String> nextPageToken, Map<String, Object> additionalProperties) {
        this.batches = batches;
        this.nextPageToken = nextPageToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="batches")
    public Optional<List<Batch>> getBatches() {
        return this.batches;
    }

    @JsonProperty(value="next_page_token")
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListBatchesResponse && this.equalTo((ListBatchesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListBatchesResponse other) {
        return this.batches.equals(other.batches) && this.nextPageToken.equals(other.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.batches, this.nextPageToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Batch>> batches = Optional.empty();
        private Optional<String> nextPageToken = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListBatchesResponse other) {
            this.batches(other.getBatches());
            this.nextPageToken(other.getNextPageToken());
            return this;
        }

        @JsonSetter(value="batches", nulls=Nulls.SKIP)
        public Builder batches(Optional<List<Batch>> batches) {
            this.batches = batches;
            return this;
        }

        public Builder batches(List<Batch> batches) {
            this.batches = Optional.ofNullable(batches);
            return this;
        }

        @JsonSetter(value="next_page_token", nulls=Nulls.SKIP)
        public Builder nextPageToken(Optional<String> nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = Optional.ofNullable(nextPageToken);
            return this;
        }

        public ListBatchesResponse build() {
            return new ListBatchesResponse(this.batches, this.nextPageToken, this.additionalProperties);
        }
    }
}

