/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.connectors;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.connectors.RawConnectorsClient;
import com.cohere.api.resources.connectors.requests.ConnectorsListRequest;
import com.cohere.api.resources.connectors.requests.ConnectorsOAuthAuthorizeRequest;
import com.cohere.api.resources.connectors.requests.CreateConnectorRequest;
import com.cohere.api.resources.connectors.requests.UpdateConnectorRequest;
import com.cohere.api.types.CreateConnectorResponse;
import com.cohere.api.types.GetConnectorResponse;
import com.cohere.api.types.ListConnectorsResponse;
import com.cohere.api.types.OAuthAuthorizeResponse;
import com.cohere.api.types.UpdateConnectorResponse;
import java.util.Map;

public class ConnectorsClient {
    protected final ClientOptions clientOptions;
    private final RawConnectorsClient rawClient;

    public ConnectorsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawConnectorsClient(clientOptions);
    }

    public RawConnectorsClient withRawResponse() {
        return this.rawClient;
    }

    public ListConnectorsResponse list() {
        return this.rawClient.list().body();
    }

    public ListConnectorsResponse list(ConnectorsListRequest request) {
        return this.rawClient.list(request).body();
    }

    public ListConnectorsResponse list(ConnectorsListRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateConnectorResponse create(CreateConnectorRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateConnectorResponse create(CreateConnectorRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetConnectorResponse get(String id) {
        return this.rawClient.get(id).body();
    }

    public GetConnectorResponse get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).body();
    }

    public Map<String, Object> delete(String id) {
        return this.rawClient.delete(id).body();
    }

    public Map<String, Object> delete(String id, RequestOptions requestOptions) {
        return this.rawClient.delete(id, requestOptions).body();
    }

    public UpdateConnectorResponse update(String id) {
        return this.rawClient.update(id).body();
    }

    public UpdateConnectorResponse update(String id, UpdateConnectorRequest request) {
        return this.rawClient.update(id, request).body();
    }

    public UpdateConnectorResponse update(String id, UpdateConnectorRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(id, request, requestOptions).body();
    }

    public OAuthAuthorizeResponse oAuthAuthorize(String id) {
        return this.rawClient.oAuthAuthorize(id).body();
    }

    public OAuthAuthorizeResponse oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request) {
        return this.rawClient.oAuthAuthorize(id, request).body();
    }

    public OAuthAuthorizeResponse oAuthAuthorize(String id, ConnectorsOAuthAuthorizeRequest request, RequestOptions requestOptions) {
        return this.rawClient.oAuthAuthorize(id, request, requestOptions).body();
    }
}

