/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.datasets.RawDatasetsClient;
import com.cohere.api.resources.datasets.requests.DatasetsCreateRequest;
import com.cohere.api.resources.datasets.requests.DatasetsListRequest;
import com.cohere.api.resources.datasets.types.DatasetsCreateResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetResponse;
import com.cohere.api.resources.datasets.types.DatasetsGetUsageResponse;
import com.cohere.api.resources.datasets.types.DatasetsListResponse;
import java.io.File;
import java.util.Map;
import java.util.Optional;

public class DatasetsClient {
    protected final ClientOptions clientOptions;
    private final RawDatasetsClient rawClient;

    public DatasetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDatasetsClient(clientOptions);
    }

    public RawDatasetsClient withRawResponse() {
        return this.rawClient;
    }

    public DatasetsListResponse list() {
        return this.rawClient.list().body();
    }

    public DatasetsListResponse list(DatasetsListRequest request) {
        return this.rawClient.list(request).body();
    }

    public DatasetsListResponse list(DatasetsListRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public DatasetsCreateResponse create(File data, Optional<File> evalData, DatasetsCreateRequest request) {
        return this.rawClient.create(data, evalData, request).body();
    }

    public DatasetsCreateResponse create(File data, Optional<File> evalData, DatasetsCreateRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(data, evalData, request, requestOptions).body();
    }

    public DatasetsGetUsageResponse getUsage() {
        return this.rawClient.getUsage().body();
    }

    public DatasetsGetUsageResponse getUsage(RequestOptions requestOptions) {
        return this.rawClient.getUsage(requestOptions).body();
    }

    public DatasetsGetResponse get(String id) {
        return this.rawClient.get(id).body();
    }

    public DatasetsGetResponse get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).body();
    }

    public Map<String, Object> delete(String id) {
        return this.rawClient.delete(id).body();
    }

    public Map<String, Object> delete(String id, RequestOptions requestOptions) {
        return this.rawClient.delete(id, requestOptions).body();
    }
}

