/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.DatasetType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DatasetsCreateRequest {
    private final Optional<List<String>> keepFields;
    private final Optional<List<String>> optionalFields;
    private final String name;
    private final DatasetType type;
    private final Optional<Boolean> keepOriginalFile;
    private final Optional<Boolean> skipMalformedInput;
    private final Optional<String> textSeparator;
    private final Optional<String> csvDelimiter;
    private final Map<String, Object> additionalProperties;

    private DatasetsCreateRequest(Optional<List<String>> keepFields, Optional<List<String>> optionalFields, String name, DatasetType type, Optional<Boolean> keepOriginalFile, Optional<Boolean> skipMalformedInput, Optional<String> textSeparator, Optional<String> csvDelimiter, Map<String, Object> additionalProperties) {
        this.keepFields = keepFields;
        this.optionalFields = optionalFields;
        this.name = name;
        this.type = type;
        this.keepOriginalFile = keepOriginalFile;
        this.skipMalformedInput = skipMalformedInput;
        this.textSeparator = textSeparator;
        this.csvDelimiter = csvDelimiter;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="keep_fields")
    public Optional<List<String>> getKeepFields() {
        return this.keepFields;
    }

    @JsonProperty(value="optional_fields")
    public Optional<List<String>> getOptionalFields() {
        return this.optionalFields;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="type")
    public DatasetType getType() {
        return this.type;
    }

    @JsonProperty(value="keep_original_file")
    public Optional<Boolean> getKeepOriginalFile() {
        return this.keepOriginalFile;
    }

    @JsonProperty(value="skip_malformed_input")
    public Optional<Boolean> getSkipMalformedInput() {
        return this.skipMalformedInput;
    }

    @JsonProperty(value="text_separator")
    public Optional<String> getTextSeparator() {
        return this.textSeparator;
    }

    @JsonProperty(value="csv_delimiter")
    public Optional<String> getCsvDelimiter() {
        return this.csvDelimiter;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetsCreateRequest && this.equalTo((DatasetsCreateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetsCreateRequest other) {
        return this.keepFields.equals(other.keepFields) && this.optionalFields.equals(other.optionalFields) && this.name.equals(other.name) && this.type.equals((Object)other.type) && this.keepOriginalFile.equals(other.keepOriginalFile) && this.skipMalformedInput.equals(other.skipMalformedInput) && this.textSeparator.equals(other.textSeparator) && this.csvDelimiter.equals(other.csvDelimiter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keepFields, this.optionalFields, this.name, this.type, this.keepOriginalFile, this.skipMalformedInput, this.textSeparator, this.csvDelimiter});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    TypeStage,
    _FinalStage {
        private String name;
        private DatasetType type;
        private Optional<String> csvDelimiter = Optional.empty();
        private Optional<String> textSeparator = Optional.empty();
        private Optional<Boolean> skipMalformedInput = Optional.empty();
        private Optional<Boolean> keepOriginalFile = Optional.empty();
        private Optional<List<String>> optionalFields = Optional.empty();
        private Optional<List<String>> keepFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DatasetsCreateRequest other) {
            this.keepFields(other.getKeepFields());
            this.optionalFields(other.getOptionalFields());
            this.name(other.getName());
            this.type(other.getType());
            this.keepOriginalFile(other.getKeepOriginalFile());
            this.skipMalformedInput(other.getSkipMalformedInput());
            this.textSeparator(other.getTextSeparator());
            this.csvDelimiter(other.getCsvDelimiter());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public TypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull DatasetType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = Optional.ofNullable(csvDelimiter);
            return this;
        }

        @Override
        @JsonSetter(value="csv_delimiter", nulls=Nulls.SKIP)
        public _FinalStage csvDelimiter(Optional<String> csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        @Override
        public _FinalStage textSeparator(String textSeparator) {
            this.textSeparator = Optional.ofNullable(textSeparator);
            return this;
        }

        @Override
        @JsonSetter(value="text_separator", nulls=Nulls.SKIP)
        public _FinalStage textSeparator(Optional<String> textSeparator) {
            this.textSeparator = textSeparator;
            return this;
        }

        @Override
        public _FinalStage skipMalformedInput(Boolean skipMalformedInput) {
            this.skipMalformedInput = Optional.ofNullable(skipMalformedInput);
            return this;
        }

        @Override
        @JsonSetter(value="skip_malformed_input", nulls=Nulls.SKIP)
        public _FinalStage skipMalformedInput(Optional<Boolean> skipMalformedInput) {
            this.skipMalformedInput = skipMalformedInput;
            return this;
        }

        @Override
        public _FinalStage keepOriginalFile(Boolean keepOriginalFile) {
            this.keepOriginalFile = Optional.ofNullable(keepOriginalFile);
            return this;
        }

        @Override
        @JsonSetter(value="keep_original_file", nulls=Nulls.SKIP)
        public _FinalStage keepOriginalFile(Optional<Boolean> keepOriginalFile) {
            this.keepOriginalFile = keepOriginalFile;
            return this;
        }

        @Override
        public _FinalStage optionalFields(String optionalFields) {
            this.optionalFields = Optional.of(Collections.singletonList(optionalFields));
            return this;
        }

        @Override
        public _FinalStage optionalFields(List<String> optionalFields) {
            this.optionalFields = Optional.ofNullable(optionalFields);
            return this;
        }

        @Override
        @JsonSetter(value="optional_fields", nulls=Nulls.SKIP)
        public _FinalStage optionalFields(Optional<List<String>> optionalFields) {
            this.optionalFields = optionalFields;
            return this;
        }

        @Override
        public _FinalStage keepFields(String keepFields) {
            this.keepFields = Optional.of(Collections.singletonList(keepFields));
            return this;
        }

        @Override
        public _FinalStage keepFields(List<String> keepFields) {
            this.keepFields = Optional.ofNullable(keepFields);
            return this;
        }

        @Override
        @JsonSetter(value="keep_fields", nulls=Nulls.SKIP)
        public _FinalStage keepFields(Optional<List<String>> keepFields) {
            this.keepFields = keepFields;
            return this;
        }

        @Override
        public DatasetsCreateRequest build() {
            return new DatasetsCreateRequest(this.keepFields, this.optionalFields, this.name, this.type, this.keepOriginalFile, this.skipMalformedInput, this.textSeparator, this.csvDelimiter, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DatasetsCreateRequest build();

        public _FinalStage keepFields(Optional<List<String>> var1);

        public _FinalStage keepFields(List<String> var1);

        public _FinalStage keepFields(String var1);

        public _FinalStage optionalFields(Optional<List<String>> var1);

        public _FinalStage optionalFields(List<String> var1);

        public _FinalStage optionalFields(String var1);

        public _FinalStage keepOriginalFile(Optional<Boolean> var1);

        public _FinalStage keepOriginalFile(Boolean var1);

        public _FinalStage skipMalformedInput(Optional<Boolean> var1);

        public _FinalStage skipMalformedInput(Boolean var1);

        public _FinalStage textSeparator(Optional<String> var1);

        public _FinalStage textSeparator(String var1);

        public _FinalStage csvDelimiter(Optional<String> var1);

        public _FinalStage csvDelimiter(String var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull DatasetType var1);
    }

    public static interface NameStage {
        public TypeStage name(@NotNull String var1);

        public Builder from(DatasetsCreateRequest var1);
    }
}

