/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.datasets.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.Dataset;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DatasetsListResponse {
    private final Optional<List<Dataset>> datasets;
    private final Map<String, Object> additionalProperties;

    private DatasetsListResponse(Optional<List<Dataset>> datasets, Map<String, Object> additionalProperties) {
        this.datasets = datasets;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="datasets")
    public Optional<List<Dataset>> getDatasets() {
        return this.datasets;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetsListResponse && this.equalTo((DatasetsListResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetsListResponse other) {
        return this.datasets.equals(other.datasets);
    }

    public int hashCode() {
        return Objects.hash(this.datasets);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Dataset>> datasets = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DatasetsListResponse other) {
            this.datasets(other.getDatasets());
            return this;
        }

        @JsonSetter(value="datasets", nulls=Nulls.SKIP)
        public Builder datasets(Optional<List<Dataset>> datasets) {
            this.datasets = datasets;
            return this;
        }

        public Builder datasets(List<Dataset> datasets) {
            this.datasets = Optional.ofNullable(datasets);
            return this;
        }

        public DatasetsListResponse build() {
            return new DatasetsListResponse(this.datasets, this.additionalProperties);
        }
    }
}

