/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.embedjobs;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.embedjobs.RawEmbedJobsClient;
import com.cohere.api.resources.embedjobs.requests.CreateEmbedJobRequest;
import com.cohere.api.types.CreateEmbedJobResponse;
import com.cohere.api.types.EmbedJob;
import com.cohere.api.types.ListEmbedJobResponse;

public class EmbedJobsClient {
    protected final ClientOptions clientOptions;
    private final RawEmbedJobsClient rawClient;

    public EmbedJobsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawEmbedJobsClient(clientOptions);
    }

    public RawEmbedJobsClient withRawResponse() {
        return this.rawClient;
    }

    public ListEmbedJobResponse list() {
        return this.rawClient.list().body();
    }

    public ListEmbedJobResponse list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public CreateEmbedJobResponse create(CreateEmbedJobRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateEmbedJobResponse create(CreateEmbedJobRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public EmbedJob get(String id) {
        return this.rawClient.get(id).body();
    }

    public EmbedJob get(String id, RequestOptions requestOptions) {
        return this.rawClient.get(id, requestOptions).body();
    }

    public void cancel(String id) {
        this.rawClient.cancel(id).body();
    }

    public void cancel(String id, RequestOptions requestOptions) {
        this.rawClient.cancel(id, requestOptions).body();
    }
}

