/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.finetuning.RawFinetuningClient;
import com.cohere.api.resources.finetuning.finetuning.types.CreateFinetunedModelResponse;
import com.cohere.api.resources.finetuning.finetuning.types.FinetunedModel;
import com.cohere.api.resources.finetuning.finetuning.types.GetFinetunedModelResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListEventsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListFinetunedModelsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.ListTrainingStepMetricsResponse;
import com.cohere.api.resources.finetuning.finetuning.types.UpdateFinetunedModelResponse;
import com.cohere.api.resources.finetuning.requests.FinetuningListEventsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningListFinetunedModelsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningListTrainingStepMetricsRequest;
import com.cohere.api.resources.finetuning.requests.FinetuningUpdateFinetunedModelRequest;
import java.util.Map;

public class FinetuningClient {
    protected final ClientOptions clientOptions;
    private final RawFinetuningClient rawClient;

    public FinetuningClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawFinetuningClient(clientOptions);
    }

    public RawFinetuningClient withRawResponse() {
        return this.rawClient;
    }

    public ListFinetunedModelsResponse listFinetunedModels() {
        return this.rawClient.listFinetunedModels().body();
    }

    public ListFinetunedModelsResponse listFinetunedModels(FinetuningListFinetunedModelsRequest request) {
        return this.rawClient.listFinetunedModels(request).body();
    }

    public ListFinetunedModelsResponse listFinetunedModels(FinetuningListFinetunedModelsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFinetunedModels(request, requestOptions).body();
    }

    public CreateFinetunedModelResponse createFinetunedModel(FinetunedModel request) {
        return this.rawClient.createFinetunedModel(request).body();
    }

    public CreateFinetunedModelResponse createFinetunedModel(FinetunedModel request, RequestOptions requestOptions) {
        return this.rawClient.createFinetunedModel(request, requestOptions).body();
    }

    public GetFinetunedModelResponse getFinetunedModel(String id) {
        return this.rawClient.getFinetunedModel(id).body();
    }

    public GetFinetunedModelResponse getFinetunedModel(String id, RequestOptions requestOptions) {
        return this.rawClient.getFinetunedModel(id, requestOptions).body();
    }

    public Map<String, Object> deleteFinetunedModel(String id) {
        return this.rawClient.deleteFinetunedModel(id).body();
    }

    public Map<String, Object> deleteFinetunedModel(String id, RequestOptions requestOptions) {
        return this.rawClient.deleteFinetunedModel(id, requestOptions).body();
    }

    public UpdateFinetunedModelResponse updateFinetunedModel(String id, FinetuningUpdateFinetunedModelRequest request) {
        return this.rawClient.updateFinetunedModel(id, request).body();
    }

    public UpdateFinetunedModelResponse updateFinetunedModel(String id, FinetuningUpdateFinetunedModelRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateFinetunedModel(id, request, requestOptions).body();
    }

    public ListEventsResponse listEvents(String finetunedModelId) {
        return this.rawClient.listEvents(finetunedModelId).body();
    }

    public ListEventsResponse listEvents(String finetunedModelId, FinetuningListEventsRequest request) {
        return this.rawClient.listEvents(finetunedModelId, request).body();
    }

    public ListEventsResponse listEvents(String finetunedModelId, FinetuningListEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEvents(finetunedModelId, request, requestOptions).body();
    }

    public ListTrainingStepMetricsResponse listTrainingStepMetrics(String finetunedModelId) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId).body();
    }

    public ListTrainingStepMetricsResponse listTrainingStepMetrics(String finetunedModelId, FinetuningListTrainingStepMetricsRequest request) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId, request).body();
    }

    public ListTrainingStepMetricsResponse listTrainingStepMetrics(String finetunedModelId, FinetuningListTrainingStepMetricsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listTrainingStepMetrics(finetunedModelId, request, requestOptions).body();
    }
}

