/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.BaseType;
import com.cohere.api.resources.finetuning.finetuning.types.Strategy;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BaseModel {
    private final Optional<String> name;
    private final Optional<String> version;
    private final BaseType baseType;
    private final Optional<Strategy> strategy;
    private final Map<String, Object> additionalProperties;

    private BaseModel(Optional<String> name, Optional<String> version, BaseType baseType, Optional<Strategy> strategy, Map<String, Object> additionalProperties) {
        this.name = name;
        this.version = version;
        this.baseType = baseType;
        this.strategy = strategy;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonProperty(value="base_type")
    public BaseType getBaseType() {
        return this.baseType;
    }

    @JsonProperty(value="strategy")
    public Optional<Strategy> getStrategy() {
        return this.strategy;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BaseModel && this.equalTo((BaseModel)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BaseModel other) {
        return this.name.equals(other.name) && this.version.equals(other.version) && this.baseType.equals((Object)other.baseType) && this.strategy.equals(other.strategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.baseType, this.strategy});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BaseTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BaseTypeStage,
    _FinalStage {
        private BaseType baseType;
        private Optional<Strategy> strategy = Optional.empty();
        private Optional<String> version = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BaseModel other) {
            this.name(other.getName());
            this.version(other.getVersion());
            this.baseType(other.getBaseType());
            this.strategy(other.getStrategy());
            return this;
        }

        @Override
        @JsonSetter(value="base_type")
        public _FinalStage baseType(@NotNull BaseType baseType) {
            this.baseType = Objects.requireNonNull(baseType, "baseType must not be null");
            return this;
        }

        @Override
        public _FinalStage strategy(Strategy strategy) {
            this.strategy = Optional.ofNullable(strategy);
            return this;
        }

        @Override
        @JsonSetter(value="strategy", nulls=Nulls.SKIP)
        public _FinalStage strategy(Optional<Strategy> strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public _FinalStage version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @Override
        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public _FinalStage version(Optional<String> version) {
            this.version = version;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public BaseModel build() {
            return new BaseModel(this.name, this.version, this.baseType, this.strategy, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BaseModel build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage version(Optional<String> var1);

        public _FinalStage version(String var1);

        public _FinalStage strategy(Optional<Strategy> var1);

        public _FinalStage strategy(Strategy var1);
    }

    public static interface BaseTypeStage {
        public _FinalStage baseType(@NotNull BaseType var1);

        public Builder from(BaseModel var1);
    }
}

