/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.Status;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Event {
    private final Optional<String> userId;
    private final Optional<Status> status;
    private final Optional<OffsetDateTime> createdAt;
    private final Map<String, Object> additionalProperties;

    private Event(Optional<String> userId, Optional<Status> status, Optional<OffsetDateTime> createdAt, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.status = status;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Event && this.equalTo((Event)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Event other) {
        return this.userId.equals(other.userId) && this.status.equals(other.status) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.status, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> userId = Optional.empty();
        private Optional<Status> status = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Event other) {
            this.userId(other.getUserId());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        public Builder status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        public Event build() {
            return new Event(this.userId, this.status, this.createdAt, this.additionalProperties);
        }
    }
}

