/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.Event;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListEventsResponse {
    private final Optional<List<Event>> events;
    private final Optional<String> nextPageToken;
    private final Optional<Integer> totalSize;
    private final Map<String, Object> additionalProperties;

    private ListEventsResponse(Optional<List<Event>> events, Optional<String> nextPageToken, Optional<Integer> totalSize, Map<String, Object> additionalProperties) {
        this.events = events;
        this.nextPageToken = nextPageToken;
        this.totalSize = totalSize;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="events")
    public Optional<List<Event>> getEvents() {
        return this.events;
    }

    @JsonProperty(value="next_page_token")
    public Optional<String> getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="total_size")
    public Optional<Integer> getTotalSize() {
        return this.totalSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListEventsResponse && this.equalTo((ListEventsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventsResponse other) {
        return this.events.equals(other.events) && this.nextPageToken.equals(other.nextPageToken) && this.totalSize.equals(other.totalSize);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.nextPageToken, this.totalSize);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<Event>> events = Optional.empty();
        private Optional<String> nextPageToken = Optional.empty();
        private Optional<Integer> totalSize = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListEventsResponse other) {
            this.events(other.getEvents());
            this.nextPageToken(other.getNextPageToken());
            this.totalSize(other.getTotalSize());
            return this;
        }

        @JsonSetter(value="events", nulls=Nulls.SKIP)
        public Builder events(Optional<List<Event>> events) {
            this.events = events;
            return this;
        }

        public Builder events(List<Event> events) {
            this.events = Optional.ofNullable(events);
            return this;
        }

        @JsonSetter(value="next_page_token", nulls=Nulls.SKIP)
        public Builder nextPageToken(Optional<String> nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = Optional.ofNullable(nextPageToken);
            return this;
        }

        @JsonSetter(value="total_size", nulls=Nulls.SKIP)
        public Builder totalSize(Optional<Integer> totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder totalSize(Integer totalSize) {
            this.totalSize = Optional.ofNullable(totalSize);
            return this;
        }

        public ListEventsResponse build() {
            return new ListEventsResponse(this.events, this.nextPageToken, this.totalSize, this.additionalProperties);
        }
    }
}

