/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.finetuning.finetuning.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.finetuning.finetuning.types.BaseModel;
import com.cohere.api.resources.finetuning.finetuning.types.Hyperparameters;
import com.cohere.api.resources.finetuning.finetuning.types.WandbConfig;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Settings {
    private final BaseModel baseModel;
    private final String datasetId;
    private final Optional<Hyperparameters> hyperparameters;
    private final Optional<Boolean> multiLabel;
    private final Optional<WandbConfig> wandb;
    private final Map<String, Object> additionalProperties;

    private Settings(BaseModel baseModel, String datasetId, Optional<Hyperparameters> hyperparameters, Optional<Boolean> multiLabel, Optional<WandbConfig> wandb, Map<String, Object> additionalProperties) {
        this.baseModel = baseModel;
        this.datasetId = datasetId;
        this.hyperparameters = hyperparameters;
        this.multiLabel = multiLabel;
        this.wandb = wandb;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="base_model")
    public BaseModel getBaseModel() {
        return this.baseModel;
    }

    @JsonProperty(value="dataset_id")
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="hyperparameters")
    public Optional<Hyperparameters> getHyperparameters() {
        return this.hyperparameters;
    }

    @JsonProperty(value="multi_label")
    public Optional<Boolean> getMultiLabel() {
        return this.multiLabel;
    }

    @JsonProperty(value="wandb")
    public Optional<WandbConfig> getWandb() {
        return this.wandb;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Settings && this.equalTo((Settings)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Settings other) {
        return this.baseModel.equals(other.baseModel) && this.datasetId.equals(other.datasetId) && this.hyperparameters.equals(other.hyperparameters) && this.multiLabel.equals(other.multiLabel) && this.wandb.equals(other.wandb);
    }

    public int hashCode() {
        return Objects.hash(this.baseModel, this.datasetId, this.hyperparameters, this.multiLabel, this.wandb);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BaseModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BaseModelStage,
    DatasetIdStage,
    _FinalStage {
        private BaseModel baseModel;
        private String datasetId;
        private Optional<WandbConfig> wandb = Optional.empty();
        private Optional<Boolean> multiLabel = Optional.empty();
        private Optional<Hyperparameters> hyperparameters = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Settings other) {
            this.baseModel(other.getBaseModel());
            this.datasetId(other.getDatasetId());
            this.hyperparameters(other.getHyperparameters());
            this.multiLabel(other.getMultiLabel());
            this.wandb(other.getWandb());
            return this;
        }

        @Override
        @JsonSetter(value="base_model")
        public DatasetIdStage baseModel(@NotNull BaseModel baseModel) {
            this.baseModel = Objects.requireNonNull(baseModel, "baseModel must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="dataset_id")
        public _FinalStage datasetId(@NotNull String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
            return this;
        }

        @Override
        public _FinalStage wandb(WandbConfig wandb) {
            this.wandb = Optional.ofNullable(wandb);
            return this;
        }

        @Override
        @JsonSetter(value="wandb", nulls=Nulls.SKIP)
        public _FinalStage wandb(Optional<WandbConfig> wandb) {
            this.wandb = wandb;
            return this;
        }

        @Override
        public _FinalStage multiLabel(Boolean multiLabel) {
            this.multiLabel = Optional.ofNullable(multiLabel);
            return this;
        }

        @Override
        @JsonSetter(value="multi_label", nulls=Nulls.SKIP)
        public _FinalStage multiLabel(Optional<Boolean> multiLabel) {
            this.multiLabel = multiLabel;
            return this;
        }

        @Override
        public _FinalStage hyperparameters(Hyperparameters hyperparameters) {
            this.hyperparameters = Optional.ofNullable(hyperparameters);
            return this;
        }

        @Override
        @JsonSetter(value="hyperparameters", nulls=Nulls.SKIP)
        public _FinalStage hyperparameters(Optional<Hyperparameters> hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        @Override
        public Settings build() {
            return new Settings(this.baseModel, this.datasetId, this.hyperparameters, this.multiLabel, this.wandb, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Settings build();

        public _FinalStage hyperparameters(Optional<Hyperparameters> var1);

        public _FinalStage hyperparameters(Hyperparameters var1);

        public _FinalStage multiLabel(Optional<Boolean> var1);

        public _FinalStage multiLabel(Boolean var1);

        public _FinalStage wandb(Optional<WandbConfig> var1);

        public _FinalStage wandb(WandbConfig var1);
    }

    public static interface DatasetIdStage {
        public _FinalStage datasetId(@NotNull String var1);
    }

    public static interface BaseModelStage {
        public DatasetIdStage baseModel(@NotNull BaseModel var1);

        public Builder from(Settings var1);
    }
}

