/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.models;

import com.cohere.api.core.ClientOptions;
import com.cohere.api.core.RequestOptions;
import com.cohere.api.resources.models.AsyncRawModelsClient;
import com.cohere.api.resources.models.requests.ModelsListRequest;
import com.cohere.api.types.GetModelResponse;
import com.cohere.api.types.ListModelsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncModelsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawModelsClient rawClient;

    public AsyncModelsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawModelsClient(clientOptions);
    }

    public AsyncRawModelsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<GetModelResponse> get(String model) {
        return this.rawClient.get(model).thenApply(response -> (GetModelResponse)response.body());
    }

    public CompletableFuture<GetModelResponse> get(String model, RequestOptions requestOptions) {
        return this.rawClient.get(model, requestOptions).thenApply(response -> (GetModelResponse)response.body());
    }

    public CompletableFuture<ListModelsResponse> list() {
        return this.rawClient.list().thenApply(response -> (ListModelsResponse)response.body());
    }

    public CompletableFuture<ListModelsResponse> list(ModelsListRequest request) {
        return this.rawClient.list(request).thenApply(response -> (ListModelsResponse)response.body());
    }

    public CompletableFuture<ListModelsResponse> list(ModelsListRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (ListModelsResponse)response.body());
    }
}

