/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.resources.v2.types.V2EmbedRequestTruncate;
import com.cohere.api.types.EmbedInput;
import com.cohere.api.types.EmbedInputType;
import com.cohere.api.types.EmbeddingType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V2EmbedRequest {
    private final Optional<List<String>> texts;
    private final Optional<List<String>> images;
    private final String model;
    private final EmbedInputType inputType;
    private final Optional<List<EmbedInput>> inputs;
    private final Optional<Integer> maxTokens;
    private final Optional<Integer> outputDimension;
    private final Optional<List<EmbeddingType>> embeddingTypes;
    private final Optional<V2EmbedRequestTruncate> truncate;
    private final Optional<Integer> priority;
    private final Map<String, Object> additionalProperties;

    private V2EmbedRequest(Optional<List<String>> texts, Optional<List<String>> images, String model, EmbedInputType inputType, Optional<List<EmbedInput>> inputs, Optional<Integer> maxTokens, Optional<Integer> outputDimension, Optional<List<EmbeddingType>> embeddingTypes, Optional<V2EmbedRequestTruncate> truncate, Optional<Integer> priority, Map<String, Object> additionalProperties) {
        this.texts = texts;
        this.images = images;
        this.model = model;
        this.inputType = inputType;
        this.inputs = inputs;
        this.maxTokens = maxTokens;
        this.outputDimension = outputDimension;
        this.embeddingTypes = embeddingTypes;
        this.truncate = truncate;
        this.priority = priority;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="texts")
    public Optional<List<String>> getTexts() {
        return this.texts;
    }

    @JsonProperty(value="images")
    public Optional<List<String>> getImages() {
        return this.images;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="input_type")
    public EmbedInputType getInputType() {
        return this.inputType;
    }

    @JsonProperty(value="inputs")
    public Optional<List<EmbedInput>> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="max_tokens")
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @JsonProperty(value="output_dimension")
    public Optional<Integer> getOutputDimension() {
        return this.outputDimension;
    }

    @JsonProperty(value="embedding_types")
    public Optional<List<EmbeddingType>> getEmbeddingTypes() {
        return this.embeddingTypes;
    }

    @JsonProperty(value="truncate")
    public Optional<V2EmbedRequestTruncate> getTruncate() {
        return this.truncate;
    }

    @JsonProperty(value="priority")
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2EmbedRequest && this.equalTo((V2EmbedRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2EmbedRequest other) {
        return this.texts.equals(other.texts) && this.images.equals(other.images) && this.model.equals(other.model) && this.inputType.equals((Object)other.inputType) && this.inputs.equals(other.inputs) && this.maxTokens.equals(other.maxTokens) && this.outputDimension.equals(other.outputDimension) && this.embeddingTypes.equals(other.embeddingTypes) && this.truncate.equals(other.truncate) && this.priority.equals(other.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.texts, this.images, this.model, this.inputType, this.inputs, this.maxTokens, this.outputDimension, this.embeddingTypes, this.truncate, this.priority});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    InputTypeStage,
    _FinalStage {
        private String model;
        private EmbedInputType inputType;
        private Optional<Integer> priority = Optional.empty();
        private Optional<V2EmbedRequestTruncate> truncate = Optional.empty();
        private Optional<List<EmbeddingType>> embeddingTypes = Optional.empty();
        private Optional<Integer> outputDimension = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<List<EmbedInput>> inputs = Optional.empty();
        private Optional<List<String>> images = Optional.empty();
        private Optional<List<String>> texts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2EmbedRequest other) {
            this.texts(other.getTexts());
            this.images(other.getImages());
            this.model(other.getModel());
            this.inputType(other.getInputType());
            this.inputs(other.getInputs());
            this.maxTokens(other.getMaxTokens());
            this.outputDimension(other.getOutputDimension());
            this.embeddingTypes(other.getEmbeddingTypes());
            this.truncate(other.getTruncate());
            this.priority(other.getPriority());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public InputTypeStage model(@NotNull String model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="input_type")
        public _FinalStage inputType(@NotNull EmbedInputType inputType) {
            this.inputType = Objects.requireNonNull(inputType, "inputType must not be null");
            return this;
        }

        @Override
        public _FinalStage priority(Integer priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }

        @Override
        @JsonSetter(value="priority", nulls=Nulls.SKIP)
        public _FinalStage priority(Optional<Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public _FinalStage truncate(V2EmbedRequestTruncate truncate) {
            this.truncate = Optional.ofNullable(truncate);
            return this;
        }

        @Override
        @JsonSetter(value="truncate", nulls=Nulls.SKIP)
        public _FinalStage truncate(Optional<V2EmbedRequestTruncate> truncate) {
            this.truncate = truncate;
            return this;
        }

        @Override
        public _FinalStage embeddingTypes(List<EmbeddingType> embeddingTypes) {
            this.embeddingTypes = Optional.ofNullable(embeddingTypes);
            return this;
        }

        @Override
        @JsonSetter(value="embedding_types", nulls=Nulls.SKIP)
        public _FinalStage embeddingTypes(Optional<List<EmbeddingType>> embeddingTypes) {
            this.embeddingTypes = embeddingTypes;
            return this;
        }

        @Override
        public _FinalStage outputDimension(Integer outputDimension) {
            this.outputDimension = Optional.ofNullable(outputDimension);
            return this;
        }

        @Override
        @JsonSetter(value="output_dimension", nulls=Nulls.SKIP)
        public _FinalStage outputDimension(Optional<Integer> outputDimension) {
            this.outputDimension = outputDimension;
            return this;
        }

        @Override
        public _FinalStage maxTokens(Integer maxTokens) {
            this.maxTokens = Optional.ofNullable(maxTokens);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens", nulls=Nulls.SKIP)
        public _FinalStage maxTokens(Optional<Integer> maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public _FinalStage inputs(List<EmbedInput> inputs) {
            this.inputs = Optional.ofNullable(inputs);
            return this;
        }

        @Override
        @JsonSetter(value="inputs", nulls=Nulls.SKIP)
        public _FinalStage inputs(Optional<List<EmbedInput>> inputs) {
            this.inputs = inputs;
            return this;
        }

        @Override
        public _FinalStage images(List<String> images) {
            this.images = Optional.ofNullable(images);
            return this;
        }

        @Override
        @JsonSetter(value="images", nulls=Nulls.SKIP)
        public _FinalStage images(Optional<List<String>> images) {
            this.images = images;
            return this;
        }

        @Override
        public _FinalStage texts(List<String> texts) {
            this.texts = Optional.ofNullable(texts);
            return this;
        }

        @Override
        @JsonSetter(value="texts", nulls=Nulls.SKIP)
        public _FinalStage texts(Optional<List<String>> texts) {
            this.texts = texts;
            return this;
        }

        @Override
        public V2EmbedRequest build() {
            return new V2EmbedRequest(this.texts, this.images, this.model, this.inputType, this.inputs, this.maxTokens, this.outputDimension, this.embeddingTypes, this.truncate, this.priority, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2EmbedRequest build();

        public _FinalStage texts(Optional<List<String>> var1);

        public _FinalStage texts(List<String> var1);

        public _FinalStage images(Optional<List<String>> var1);

        public _FinalStage images(List<String> var1);

        public _FinalStage inputs(Optional<List<EmbedInput>> var1);

        public _FinalStage inputs(List<EmbedInput> var1);

        public _FinalStage maxTokens(Optional<Integer> var1);

        public _FinalStage maxTokens(Integer var1);

        public _FinalStage outputDimension(Optional<Integer> var1);

        public _FinalStage outputDimension(Integer var1);

        public _FinalStage embeddingTypes(Optional<List<EmbeddingType>> var1);

        public _FinalStage embeddingTypes(List<EmbeddingType> var1);

        public _FinalStage truncate(Optional<V2EmbedRequestTruncate> var1);

        public _FinalStage truncate(V2EmbedRequestTruncate var1);

        public _FinalStage priority(Optional<Integer> var1);

        public _FinalStage priority(Integer var1);
    }

    public static interface InputTypeStage {
        public _FinalStage inputType(@NotNull EmbedInputType var1);
    }

    public static interface ModelStage {
        public InputTypeStage model(@NotNull String var1);

        public Builder from(V2EmbedRequest var1);
    }
}

