/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.resources.v2.requests;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class V2RerankRequest {
    private final String model;
    private final String query;
    private final List<String> documents;
    private final Optional<Integer> topN;
    private final Optional<Integer> maxTokensPerDoc;
    private final Optional<Integer> priority;
    private final Map<String, Object> additionalProperties;

    private V2RerankRequest(String model, String query, List<String> documents, Optional<Integer> topN, Optional<Integer> maxTokensPerDoc, Optional<Integer> priority, Map<String, Object> additionalProperties) {
        this.model = model;
        this.query = query;
        this.documents = documents;
        this.topN = topN;
        this.maxTokensPerDoc = maxTokensPerDoc;
        this.priority = priority;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="documents")
    public List<String> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="top_n")
    public Optional<Integer> getTopN() {
        return this.topN;
    }

    @JsonProperty(value="max_tokens_per_doc")
    public Optional<Integer> getMaxTokensPerDoc() {
        return this.maxTokensPerDoc;
    }

    @JsonProperty(value="priority")
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof V2RerankRequest && this.equalTo((V2RerankRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(V2RerankRequest other) {
        return this.model.equals(other.model) && this.query.equals(other.query) && this.documents.equals(other.documents) && this.topN.equals(other.topN) && this.maxTokensPerDoc.equals(other.maxTokensPerDoc) && this.priority.equals(other.priority);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.query, this.documents, this.topN, this.maxTokensPerDoc, this.priority);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    QueryStage,
    _FinalStage {
        private String model;
        private String query;
        private Optional<Integer> priority = Optional.empty();
        private Optional<Integer> maxTokensPerDoc = Optional.empty();
        private Optional<Integer> topN = Optional.empty();
        private List<String> documents = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(V2RerankRequest other) {
            this.model(other.getModel());
            this.query(other.getQuery());
            this.documents(other.getDocuments());
            this.topN(other.getTopN());
            this.maxTokensPerDoc(other.getMaxTokensPerDoc());
            this.priority(other.getPriority());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public QueryStage model(@NotNull String model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(@NotNull String query) {
            this.query = Objects.requireNonNull(query, "query must not be null");
            return this;
        }

        @Override
        public _FinalStage priority(Integer priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }

        @Override
        @JsonSetter(value="priority", nulls=Nulls.SKIP)
        public _FinalStage priority(Optional<Integer> priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public _FinalStage maxTokensPerDoc(Integer maxTokensPerDoc) {
            this.maxTokensPerDoc = Optional.ofNullable(maxTokensPerDoc);
            return this;
        }

        @Override
        @JsonSetter(value="max_tokens_per_doc", nulls=Nulls.SKIP)
        public _FinalStage maxTokensPerDoc(Optional<Integer> maxTokensPerDoc) {
            this.maxTokensPerDoc = maxTokensPerDoc;
            return this;
        }

        @Override
        public _FinalStage topN(Integer topN) {
            this.topN = Optional.ofNullable(topN);
            return this;
        }

        @Override
        @JsonSetter(value="top_n", nulls=Nulls.SKIP)
        public _FinalStage topN(Optional<Integer> topN) {
            this.topN = topN;
            return this;
        }

        @Override
        public _FinalStage addAllDocuments(List<String> documents) {
            this.documents.addAll(documents);
            return this;
        }

        @Override
        public _FinalStage addDocuments(String documents) {
            this.documents.add(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(List<String> documents) {
            this.documents.clear();
            this.documents.addAll(documents);
            return this;
        }

        @Override
        public V2RerankRequest build() {
            return new V2RerankRequest(this.model, this.query, this.documents, this.topN, this.maxTokensPerDoc, this.priority, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public V2RerankRequest build();

        public _FinalStage documents(List<String> var1);

        public _FinalStage addDocuments(String var1);

        public _FinalStage addAllDocuments(List<String> var1);

        public _FinalStage topN(Optional<Integer> var1);

        public _FinalStage topN(Integer var1);

        public _FinalStage maxTokensPerDoc(Optional<Integer> var1);

        public _FinalStage maxTokensPerDoc(Integer var1);

        public _FinalStage priority(Optional<Integer> var1);

        public _FinalStage priority(Integer var1);
    }

    public static interface QueryStage {
        public _FinalStage query(@NotNull String var1);
    }

    public static interface ModelStage {
        public QueryStage model(@NotNull String var1);

        public Builder from(V2RerankRequest var1);
    }
}

