/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApiMetaApiVersion {
    private final String version;
    private final Optional<Boolean> isDeprecated;
    private final Optional<Boolean> isExperimental;
    private final Map<String, Object> additionalProperties;

    private ApiMetaApiVersion(String version, Optional<Boolean> isDeprecated, Optional<Boolean> isExperimental, Map<String, Object> additionalProperties) {
        this.version = version;
        this.isDeprecated = isDeprecated;
        this.isExperimental = isExperimental;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="is_deprecated")
    public Optional<Boolean> getIsDeprecated() {
        return this.isDeprecated;
    }

    @JsonProperty(value="is_experimental")
    public Optional<Boolean> getIsExperimental() {
        return this.isExperimental;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiMetaApiVersion && this.equalTo((ApiMetaApiVersion)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiMetaApiVersion other) {
        return this.version.equals(other.version) && this.isDeprecated.equals(other.isDeprecated) && this.isExperimental.equals(other.isExperimental);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.isDeprecated, this.isExperimental);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VersionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VersionStage,
    _FinalStage {
        private String version;
        private Optional<Boolean> isExperimental = Optional.empty();
        private Optional<Boolean> isDeprecated = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ApiMetaApiVersion other) {
            this.version(other.getVersion());
            this.isDeprecated(other.getIsDeprecated());
            this.isExperimental(other.getIsExperimental());
            return this;
        }

        @Override
        @JsonSetter(value="version")
        public _FinalStage version(@NotNull String version) {
            this.version = Objects.requireNonNull(version, "version must not be null");
            return this;
        }

        @Override
        public _FinalStage isExperimental(Boolean isExperimental) {
            this.isExperimental = Optional.ofNullable(isExperimental);
            return this;
        }

        @Override
        @JsonSetter(value="is_experimental", nulls=Nulls.SKIP)
        public _FinalStage isExperimental(Optional<Boolean> isExperimental) {
            this.isExperimental = isExperimental;
            return this;
        }

        @Override
        public _FinalStage isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = Optional.ofNullable(isDeprecated);
            return this;
        }

        @Override
        @JsonSetter(value="is_deprecated", nulls=Nulls.SKIP)
        public _FinalStage isDeprecated(Optional<Boolean> isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        @Override
        public ApiMetaApiVersion build() {
            return new ApiMetaApiVersion(this.version, this.isDeprecated, this.isExperimental, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ApiMetaApiVersion build();

        public _FinalStage isDeprecated(Optional<Boolean> var1);

        public _FinalStage isDeprecated(Boolean var1);

        public _FinalStage isExperimental(Optional<Boolean> var1);

        public _FinalStage isExperimental(Boolean var1);
    }

    public static interface VersionStage {
        public _FinalStage version(@NotNull String var1);

        public Builder from(ApiMetaApiVersion var1);
    }
}

