/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatMessageStartEventDeltaMessage {
    private final Optional<String> role;
    private final Map<String, Object> additionalProperties;

    private ChatMessageStartEventDeltaMessage(Optional<String> role, Map<String, Object> additionalProperties) {
        this.role = role;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="role")
    public Optional<String> getRole() {
        return this.role;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatMessageStartEventDeltaMessage && this.equalTo((ChatMessageStartEventDeltaMessage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatMessageStartEventDeltaMessage other) {
        return this.role.equals(other.role);
    }

    public int hashCode() {
        return Objects.hash(this.role);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> role = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatMessageStartEventDeltaMessage other) {
            this.role(other.getRole());
            return this;
        }

        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public Builder role(Optional<String> role) {
            this.role = role;
            return this;
        }

        public Builder role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        public ChatMessageStartEventDeltaMessage build() {
            return new ChatMessageStartEventDeltaMessage(this.role, this.additionalProperties);
        }
    }
}

