/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.AssistantMessage;
import com.cohere.api.types.SystemMessageV2;
import com.cohere.api.types.ToolMessageV2;
import com.cohere.api.types.UserMessageV2;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class ChatMessageV2 {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ChatMessageV2(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static ChatMessageV2 user(UserMessageV2 value) {
        return new ChatMessageV2(new UserValue(value));
    }

    public static ChatMessageV2 assistant(AssistantMessage value) {
        return new ChatMessageV2(new AssistantValue(value));
    }

    public static ChatMessageV2 system(SystemMessageV2 value) {
        return new ChatMessageV2(new SystemValue(value));
    }

    public static ChatMessageV2 tool(ToolMessageV2 value) {
        return new ChatMessageV2(new ToolValue(value));
    }

    public boolean isUser() {
        return this.value instanceof UserValue;
    }

    public boolean isAssistant() {
        return this.value instanceof AssistantValue;
    }

    public boolean isSystem() {
        return this.value instanceof SystemValue;
    }

    public boolean isTool() {
        return this.value instanceof ToolValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<UserMessageV2> getUser() {
        if (this.isUser()) {
            return Optional.of(((UserValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<AssistantMessage> getAssistant() {
        if (this.isAssistant()) {
            return Optional.of(((AssistantValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SystemMessageV2> getSystem() {
        if (this.isSystem()) {
            return Optional.of(((SystemValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ToolMessageV2> getTool() {
        if (this.isTool()) {
            return Optional.of(((ToolValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"role"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "ChatMessageV2{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool")
    @JsonIgnoreProperties(value={"role"})
    private static final class ToolValue
    implements Value {
        @JsonUnwrapped
        private ToolMessageV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolValue() {
        }

        private ToolValue(ToolMessageV2 value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTool(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolValue && this.equalTo((ToolValue)other);
        }

        private boolean equalTo(ToolValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ChatMessageV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="system")
    @JsonIgnoreProperties(value={"role"})
    private static final class SystemValue
    implements Value {
        @JsonUnwrapped
        private SystemMessageV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SystemValue() {
        }

        private SystemValue(SystemMessageV2 value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSystem(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SystemValue && this.equalTo((SystemValue)other);
        }

        private boolean equalTo(SystemValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ChatMessageV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="assistant")
    @JsonIgnoreProperties(value={"role"})
    private static final class AssistantValue
    implements Value {
        @JsonUnwrapped
        private AssistantMessage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private AssistantValue() {
        }

        private AssistantValue(AssistantMessage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitAssistant(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof AssistantValue && this.equalTo((AssistantValue)other);
        }

        private boolean equalTo(AssistantValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ChatMessageV2{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="user")
    @JsonIgnoreProperties(value={"role"})
    private static final class UserValue
    implements Value {
        @JsonUnwrapped
        private UserMessageV2 value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UserValue() {
        }

        private UserValue(UserMessageV2 value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitUser(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UserValue && this.equalTo((UserValue)other);
        }

        private boolean equalTo(UserValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ChatMessageV2{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="role", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=UserValue.class), @JsonSubTypes.Type(value=AssistantValue.class), @JsonSubTypes.Type(value=SystemValue.class), @JsonSubTypes.Type(value=ToolValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitUser(UserMessageV2 var1);

        public T visitAssistant(AssistantMessage var1);

        public T visitSystem(SystemMessageV2 var1);

        public T visitTool(ToolMessageV2 var1);

        public T _visitUnknown(Object var1);
    }
}

