/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatSearchQuery;
import com.cohere.api.types.ChatSearchResultConnector;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatSearchResult {
    private final Optional<ChatSearchQuery> searchQuery;
    private final ChatSearchResultConnector connector;
    private final List<String> documentIds;
    private final Optional<String> errorMessage;
    private final Optional<Boolean> continueOnFailure;
    private final Map<String, Object> additionalProperties;

    private ChatSearchResult(Optional<ChatSearchQuery> searchQuery, ChatSearchResultConnector connector, List<String> documentIds, Optional<String> errorMessage, Optional<Boolean> continueOnFailure, Map<String, Object> additionalProperties) {
        this.searchQuery = searchQuery;
        this.connector = connector;
        this.documentIds = documentIds;
        this.errorMessage = errorMessage;
        this.continueOnFailure = continueOnFailure;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="search_query")
    public Optional<ChatSearchQuery> getSearchQuery() {
        return this.searchQuery;
    }

    @JsonProperty(value="connector")
    public ChatSearchResultConnector getConnector() {
        return this.connector;
    }

    @JsonProperty(value="document_ids")
    public List<String> getDocumentIds() {
        return this.documentIds;
    }

    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="continue_on_failure")
    public Optional<Boolean> getContinueOnFailure() {
        return this.continueOnFailure;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatSearchResult && this.equalTo((ChatSearchResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatSearchResult other) {
        return this.searchQuery.equals(other.searchQuery) && this.connector.equals(other.connector) && this.documentIds.equals(other.documentIds) && this.errorMessage.equals(other.errorMessage) && this.continueOnFailure.equals(other.continueOnFailure);
    }

    public int hashCode() {
        return Objects.hash(this.searchQuery, this.connector, this.documentIds, this.errorMessage, this.continueOnFailure);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConnectorStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConnectorStage,
    _FinalStage {
        private ChatSearchResultConnector connector;
        private Optional<Boolean> continueOnFailure = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private List<String> documentIds = new ArrayList<String>();
        private Optional<ChatSearchQuery> searchQuery = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChatSearchResult other) {
            this.searchQuery(other.getSearchQuery());
            this.connector(other.getConnector());
            this.documentIds(other.getDocumentIds());
            this.errorMessage(other.getErrorMessage());
            this.continueOnFailure(other.getContinueOnFailure());
            return this;
        }

        @Override
        @JsonSetter(value="connector")
        public _FinalStage connector(@NotNull ChatSearchResultConnector connector) {
            this.connector = Objects.requireNonNull(connector, "connector must not be null");
            return this;
        }

        @Override
        public _FinalStage continueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = Optional.ofNullable(continueOnFailure);
            return this;
        }

        @Override
        @JsonSetter(value="continue_on_failure", nulls=Nulls.SKIP)
        public _FinalStage continueOnFailure(Optional<Boolean> continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
            return this;
        }

        @Override
        public _FinalStage errorMessage(String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        @JsonSetter(value="error_message", nulls=Nulls.SKIP)
        public _FinalStage errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public _FinalStage addAllDocumentIds(List<String> documentIds) {
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public _FinalStage addDocumentIds(String documentIds) {
            this.documentIds.add(documentIds);
            return this;
        }

        @Override
        @JsonSetter(value="document_ids", nulls=Nulls.SKIP)
        public _FinalStage documentIds(List<String> documentIds) {
            this.documentIds.clear();
            this.documentIds.addAll(documentIds);
            return this;
        }

        @Override
        public _FinalStage searchQuery(ChatSearchQuery searchQuery) {
            this.searchQuery = Optional.ofNullable(searchQuery);
            return this;
        }

        @Override
        @JsonSetter(value="search_query", nulls=Nulls.SKIP)
        public _FinalStage searchQuery(Optional<ChatSearchQuery> searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        @Override
        public ChatSearchResult build() {
            return new ChatSearchResult(this.searchQuery, this.connector, this.documentIds, this.errorMessage, this.continueOnFailure, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChatSearchResult build();

        public _FinalStage searchQuery(Optional<ChatSearchQuery> var1);

        public _FinalStage searchQuery(ChatSearchQuery var1);

        public _FinalStage documentIds(List<String> var1);

        public _FinalStage addDocumentIds(String var1);

        public _FinalStage addAllDocumentIds(List<String> var1);

        public _FinalStage errorMessage(Optional<String> var1);

        public _FinalStage errorMessage(String var1);

        public _FinalStage continueOnFailure(Optional<Boolean> var1);

        public _FinalStage continueOnFailure(Boolean var1);
    }

    public static interface ConnectorStage {
        public _FinalStage connector(@NotNull ChatSearchResultConnector var1);

        public Builder from(ChatSearchResult var1);
    }
}

