/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ChatSearchResult;
import com.cohere.api.types.IChatStreamEvent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChatSearchResultsEvent
implements IChatStreamEvent {
    private final Optional<List<ChatSearchResult>> searchResults;
    private final Optional<List<Map<String, String>>> documents;
    private final Map<String, Object> additionalProperties;

    private ChatSearchResultsEvent(Optional<List<ChatSearchResult>> searchResults, Optional<List<Map<String, String>>> documents, Map<String, Object> additionalProperties) {
        this.searchResults = searchResults;
        this.documents = documents;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="search_results")
    public Optional<List<ChatSearchResult>> getSearchResults() {
        return this.searchResults;
    }

    @JsonProperty(value="documents")
    public Optional<List<Map<String, String>>> getDocuments() {
        return this.documents;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChatSearchResultsEvent && this.equalTo((ChatSearchResultsEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChatSearchResultsEvent other) {
        return this.searchResults.equals(other.searchResults) && this.documents.equals(other.documents);
    }

    public int hashCode() {
        return Objects.hash(this.searchResults, this.documents);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<ChatSearchResult>> searchResults = Optional.empty();
        private Optional<List<Map<String, String>>> documents = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ChatSearchResultsEvent other) {
            this.searchResults(other.getSearchResults());
            this.documents(other.getDocuments());
            return this;
        }

        @JsonSetter(value="search_results", nulls=Nulls.SKIP)
        public Builder searchResults(Optional<List<ChatSearchResult>> searchResults) {
            this.searchResults = searchResults;
            return this;
        }

        public Builder searchResults(List<ChatSearchResult> searchResults) {
            this.searchResults = Optional.ofNullable(searchResults);
            return this;
        }

        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public Builder documents(Optional<List<Map<String, String>>> documents) {
            this.documents = documents;
            return this;
        }

        public Builder documents(List<Map<String, String>> documents) {
            this.documents = Optional.ofNullable(documents);
            return this;
        }

        public ChatSearchResultsEvent build() {
            return new ChatSearchResultsEvent(this.searchResults, this.documents, this.additionalProperties);
        }
    }
}

