/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ClassifyResponseClassificationsItemClassificationType;
import com.cohere.api.types.ClassifyResponseClassificationsItemLabelsValue;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ClassifyResponseClassificationsItem {
    private final String id;
    private final Optional<String> input;
    private final Optional<String> prediction;
    private final List<String> predictions;
    private final Optional<Float> confidence;
    private final List<Float> confidences;
    private final Map<String, ClassifyResponseClassificationsItemLabelsValue> labels;
    private final ClassifyResponseClassificationsItemClassificationType classificationType;
    private final Map<String, Object> additionalProperties;

    private ClassifyResponseClassificationsItem(String id, Optional<String> input, Optional<String> prediction, List<String> predictions, Optional<Float> confidence, List<Float> confidences, Map<String, ClassifyResponseClassificationsItemLabelsValue> labels, ClassifyResponseClassificationsItemClassificationType classificationType, Map<String, Object> additionalProperties) {
        this.id = id;
        this.input = input;
        this.prediction = prediction;
        this.predictions = predictions;
        this.confidence = confidence;
        this.confidences = confidences;
        this.labels = labels;
        this.classificationType = classificationType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="input")
    public Optional<String> getInput() {
        return this.input;
    }

    @JsonProperty(value="prediction")
    public Optional<String> getPrediction() {
        return this.prediction;
    }

    @JsonProperty(value="predictions")
    public List<String> getPredictions() {
        return this.predictions;
    }

    @JsonProperty(value="confidence")
    public Optional<Float> getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="confidences")
    public List<Float> getConfidences() {
        return this.confidences;
    }

    @JsonProperty(value="labels")
    public Map<String, ClassifyResponseClassificationsItemLabelsValue> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="classification_type")
    public ClassifyResponseClassificationsItemClassificationType getClassificationType() {
        return this.classificationType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClassifyResponseClassificationsItem && this.equalTo((ClassifyResponseClassificationsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClassifyResponseClassificationsItem other) {
        return this.id.equals(other.id) && this.input.equals(other.input) && this.prediction.equals(other.prediction) && this.predictions.equals(other.predictions) && this.confidence.equals(other.confidence) && this.confidences.equals(other.confidences) && this.labels.equals(other.labels) && this.classificationType.equals((Object)other.classificationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.input, this.prediction, this.predictions, this.confidence, this.confidences, this.labels, this.classificationType});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ClassificationTypeStage,
    _FinalStage {
        private String id;
        private ClassifyResponseClassificationsItemClassificationType classificationType;
        private Map<String, ClassifyResponseClassificationsItemLabelsValue> labels = new LinkedHashMap<String, ClassifyResponseClassificationsItemLabelsValue>();
        private List<Float> confidences = new ArrayList<Float>();
        private Optional<Float> confidence = Optional.empty();
        private List<String> predictions = new ArrayList<String>();
        private Optional<String> prediction = Optional.empty();
        private Optional<String> input = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ClassifyResponseClassificationsItem other) {
            this.id(other.getId());
            this.input(other.getInput());
            this.prediction(other.getPrediction());
            this.predictions(other.getPredictions());
            this.confidence(other.getConfidence());
            this.confidences(other.getConfidences());
            this.labels(other.getLabels());
            this.classificationType(other.getClassificationType());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ClassificationTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="classification_type")
        public _FinalStage classificationType(@NotNull ClassifyResponseClassificationsItemClassificationType classificationType) {
            this.classificationType = Objects.requireNonNull(classificationType, "classificationType must not be null");
            return this;
        }

        @Override
        public _FinalStage labels(String key, ClassifyResponseClassificationsItemLabelsValue value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.putAll(labels);
            return this;
        }

        @Override
        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> labels) {
            this.labels.clear();
            this.labels.putAll(labels);
            return this;
        }

        @Override
        public _FinalStage addAllConfidences(List<Float> confidences) {
            this.confidences.addAll(confidences);
            return this;
        }

        @Override
        public _FinalStage addConfidences(Float confidences) {
            this.confidences.add(confidences);
            return this;
        }

        @Override
        @JsonSetter(value="confidences", nulls=Nulls.SKIP)
        public _FinalStage confidences(List<Float> confidences) {
            this.confidences.clear();
            this.confidences.addAll(confidences);
            return this;
        }

        @Override
        public _FinalStage confidence(Float confidence) {
            this.confidence = Optional.ofNullable(confidence);
            return this;
        }

        @Override
        @JsonSetter(value="confidence", nulls=Nulls.SKIP)
        public _FinalStage confidence(Optional<Float> confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public _FinalStage addAllPredictions(List<String> predictions) {
            this.predictions.addAll(predictions);
            return this;
        }

        @Override
        public _FinalStage addPredictions(String predictions) {
            this.predictions.add(predictions);
            return this;
        }

        @Override
        @JsonSetter(value="predictions", nulls=Nulls.SKIP)
        public _FinalStage predictions(List<String> predictions) {
            this.predictions.clear();
            this.predictions.addAll(predictions);
            return this;
        }

        @Override
        public _FinalStage prediction(String prediction) {
            this.prediction = Optional.ofNullable(prediction);
            return this;
        }

        @Override
        @JsonSetter(value="prediction", nulls=Nulls.SKIP)
        public _FinalStage prediction(Optional<String> prediction) {
            this.prediction = prediction;
            return this;
        }

        @Override
        public _FinalStage input(String input) {
            this.input = Optional.ofNullable(input);
            return this;
        }

        @Override
        @JsonSetter(value="input", nulls=Nulls.SKIP)
        public _FinalStage input(Optional<String> input) {
            this.input = input;
            return this;
        }

        @Override
        public ClassifyResponseClassificationsItem build() {
            return new ClassifyResponseClassificationsItem(this.id, this.input, this.prediction, this.predictions, this.confidence, this.confidences, this.labels, this.classificationType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ClassifyResponseClassificationsItem build();

        public _FinalStage input(Optional<String> var1);

        public _FinalStage input(String var1);

        public _FinalStage prediction(Optional<String> var1);

        public _FinalStage prediction(String var1);

        public _FinalStage predictions(List<String> var1);

        public _FinalStage addPredictions(String var1);

        public _FinalStage addAllPredictions(List<String> var1);

        public _FinalStage confidence(Optional<Float> var1);

        public _FinalStage confidence(Float var1);

        public _FinalStage confidences(List<Float> var1);

        public _FinalStage addConfidences(Float var1);

        public _FinalStage addAllConfidences(List<Float> var1);

        public _FinalStage labels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage putAllLabels(Map<String, ClassifyResponseClassificationsItemLabelsValue> var1);

        public _FinalStage labels(String var1, ClassifyResponseClassificationsItemLabelsValue var2);
    }

    public static interface ClassificationTypeStage {
        public _FinalStage classificationType(@NotNull ClassifyResponseClassificationsItemClassificationType var1);
    }

    public static interface IdStage {
        public ClassificationTypeStage id(@NotNull String var1);

        public Builder from(ClassifyResponseClassificationsItem var1);
    }
}

