/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConnectorOAuth {
    private final Optional<String> clientId;
    private final Optional<String> clientSecret;
    private final String authorizeUrl;
    private final String tokenUrl;
    private final Optional<String> scope;
    private final Map<String, Object> additionalProperties;

    private ConnectorOAuth(Optional<String> clientId, Optional<String> clientSecret, String authorizeUrl, String tokenUrl, Optional<String> scope, Map<String, Object> additionalProperties) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authorizeUrl = authorizeUrl;
        this.tokenUrl = tokenUrl;
        this.scope = scope;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="client_id")
    public Optional<String> getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_secret")
    public Optional<String> getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="authorize_url")
    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    @JsonProperty(value="token_url")
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @JsonProperty(value="scope")
    public Optional<String> getScope() {
        return this.scope;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConnectorOAuth && this.equalTo((ConnectorOAuth)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConnectorOAuth other) {
        return this.clientId.equals(other.clientId) && this.clientSecret.equals(other.clientSecret) && this.authorizeUrl.equals(other.authorizeUrl) && this.tokenUrl.equals(other.tokenUrl) && this.scope.equals(other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.authorizeUrl, this.tokenUrl, this.scope);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AuthorizeUrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AuthorizeUrlStage,
    TokenUrlStage,
    _FinalStage {
        private String authorizeUrl;
        private String tokenUrl;
        private Optional<String> scope = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        private Optional<String> clientId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConnectorOAuth other) {
            this.clientId(other.getClientId());
            this.clientSecret(other.getClientSecret());
            this.authorizeUrl(other.getAuthorizeUrl());
            this.tokenUrl(other.getTokenUrl());
            this.scope(other.getScope());
            return this;
        }

        @Override
        @JsonSetter(value="authorize_url")
        public TokenUrlStage authorizeUrl(@NotNull String authorizeUrl) {
            this.authorizeUrl = Objects.requireNonNull(authorizeUrl, "authorizeUrl must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="token_url")
        public _FinalStage tokenUrl(@NotNull String tokenUrl) {
            this.tokenUrl = Objects.requireNonNull(tokenUrl, "tokenUrl must not be null");
            return this;
        }

        @Override
        public _FinalStage scope(String scope) {
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        @Override
        @JsonSetter(value="scope", nulls=Nulls.SKIP)
        public _FinalStage scope(Optional<String> scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public _FinalStage clientSecret(String clientSecret) {
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        @Override
        @JsonSetter(value="client_secret", nulls=Nulls.SKIP)
        public _FinalStage clientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Override
        public _FinalStage clientId(String clientId) {
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        @Override
        @JsonSetter(value="client_id", nulls=Nulls.SKIP)
        public _FinalStage clientId(Optional<String> clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public ConnectorOAuth build() {
            return new ConnectorOAuth(this.clientId, this.clientSecret, this.authorizeUrl, this.tokenUrl, this.scope, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConnectorOAuth build();

        public _FinalStage clientId(Optional<String> var1);

        public _FinalStage clientId(String var1);

        public _FinalStage clientSecret(Optional<String> var1);

        public _FinalStage clientSecret(String var1);

        public _FinalStage scope(Optional<String> var1);

        public _FinalStage scope(String var1);
    }

    public static interface TokenUrlStage {
        public _FinalStage tokenUrl(@NotNull String var1);
    }

    public static interface AuthorizeUrlStage {
        public TokenUrlStage authorizeUrl(@NotNull String var1);

        public Builder from(ConnectorOAuth var1);
    }
}

