/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateConnectorOAuth {
    private final Optional<String> clientId;
    private final Optional<String> clientSecret;
    private final Optional<String> authorizeUrl;
    private final Optional<String> tokenUrl;
    private final Optional<String> scope;
    private final Map<String, Object> additionalProperties;

    private CreateConnectorOAuth(Optional<String> clientId, Optional<String> clientSecret, Optional<String> authorizeUrl, Optional<String> tokenUrl, Optional<String> scope, Map<String, Object> additionalProperties) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authorizeUrl = authorizeUrl;
        this.tokenUrl = tokenUrl;
        this.scope = scope;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="client_id")
    public Optional<String> getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_secret")
    public Optional<String> getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="authorize_url")
    public Optional<String> getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    @JsonProperty(value="token_url")
    public Optional<String> getTokenUrl() {
        return this.tokenUrl;
    }

    @JsonProperty(value="scope")
    public Optional<String> getScope() {
        return this.scope;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateConnectorOAuth && this.equalTo((CreateConnectorOAuth)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateConnectorOAuth other) {
        return this.clientId.equals(other.clientId) && this.clientSecret.equals(other.clientSecret) && this.authorizeUrl.equals(other.authorizeUrl) && this.tokenUrl.equals(other.tokenUrl) && this.scope.equals(other.scope);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.authorizeUrl, this.tokenUrl, this.scope);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> clientId = Optional.empty();
        private Optional<String> clientSecret = Optional.empty();
        private Optional<String> authorizeUrl = Optional.empty();
        private Optional<String> tokenUrl = Optional.empty();
        private Optional<String> scope = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateConnectorOAuth other) {
            this.clientId(other.getClientId());
            this.clientSecret(other.getClientSecret());
            this.authorizeUrl(other.getAuthorizeUrl());
            this.tokenUrl(other.getTokenUrl());
            this.scope(other.getScope());
            return this;
        }

        @JsonSetter(value="client_id", nulls=Nulls.SKIP)
        public Builder clientId(Optional<String> clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = Optional.ofNullable(clientId);
            return this;
        }

        @JsonSetter(value="client_secret", nulls=Nulls.SKIP)
        public Builder clientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        @JsonSetter(value="authorize_url", nulls=Nulls.SKIP)
        public Builder authorizeUrl(Optional<String> authorizeUrl) {
            this.authorizeUrl = authorizeUrl;
            return this;
        }

        public Builder authorizeUrl(String authorizeUrl) {
            this.authorizeUrl = Optional.ofNullable(authorizeUrl);
            return this;
        }

        @JsonSetter(value="token_url", nulls=Nulls.SKIP)
        public Builder tokenUrl(Optional<String> tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = Optional.ofNullable(tokenUrl);
            return this;
        }

        @JsonSetter(value="scope", nulls=Nulls.SKIP)
        public Builder scope(Optional<String> scope) {
            this.scope = scope;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = Optional.ofNullable(scope);
            return this;
        }

        public CreateConnectorOAuth build() {
            return new CreateConnectorOAuth(this.clientId, this.clientSecret, this.authorizeUrl, this.tokenUrl, this.scope, this.additionalProperties);
        }
    }
}

