/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DatasetPart {
    private final String id;
    private final String name;
    private final Optional<String> url;
    private final Optional<Integer> index;
    private final Optional<Integer> sizeBytes;
    private final Optional<Integer> numRows;
    private final Optional<String> originalUrl;
    private final Optional<List<String>> samples;
    private final Map<String, Object> additionalProperties;

    private DatasetPart(String id, String name, Optional<String> url, Optional<Integer> index, Optional<Integer> sizeBytes, Optional<Integer> numRows, Optional<String> originalUrl, Optional<List<String>> samples, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.index = index;
        this.sizeBytes = sizeBytes;
        this.numRows = numRows;
        this.originalUrl = originalUrl;
        this.samples = samples;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="index")
    public Optional<Integer> getIndex() {
        return this.index;
    }

    @JsonProperty(value="size_bytes")
    public Optional<Integer> getSizeBytes() {
        return this.sizeBytes;
    }

    @JsonProperty(value="num_rows")
    public Optional<Integer> getNumRows() {
        return this.numRows;
    }

    @JsonProperty(value="original_url")
    public Optional<String> getOriginalUrl() {
        return this.originalUrl;
    }

    @JsonProperty(value="samples")
    public Optional<List<String>> getSamples() {
        return this.samples;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DatasetPart && this.equalTo((DatasetPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DatasetPart other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.url.equals(other.url) && this.index.equals(other.index) && this.sizeBytes.equals(other.sizeBytes) && this.numRows.equals(other.numRows) && this.originalUrl.equals(other.originalUrl) && this.samples.equals(other.samples);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.url, this.index, this.sizeBytes, this.numRows, this.originalUrl, this.samples);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<List<String>> samples = Optional.empty();
        private Optional<String> originalUrl = Optional.empty();
        private Optional<Integer> numRows = Optional.empty();
        private Optional<Integer> sizeBytes = Optional.empty();
        private Optional<Integer> index = Optional.empty();
        private Optional<String> url = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DatasetPart other) {
            this.id(other.getId());
            this.name(other.getName());
            this.url(other.getUrl());
            this.index(other.getIndex());
            this.sizeBytes(other.getSizeBytes());
            this.numRows(other.getNumRows());
            this.originalUrl(other.getOriginalUrl());
            this.samples(other.getSamples());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage samples(List<String> samples) {
            this.samples = Optional.ofNullable(samples);
            return this;
        }

        @Override
        @JsonSetter(value="samples", nulls=Nulls.SKIP)
        public _FinalStage samples(Optional<List<String>> samples) {
            this.samples = samples;
            return this;
        }

        @Override
        public _FinalStage originalUrl(String originalUrl) {
            this.originalUrl = Optional.ofNullable(originalUrl);
            return this;
        }

        @Override
        @JsonSetter(value="original_url", nulls=Nulls.SKIP)
        public _FinalStage originalUrl(Optional<String> originalUrl) {
            this.originalUrl = originalUrl;
            return this;
        }

        @Override
        public _FinalStage numRows(Integer numRows) {
            this.numRows = Optional.ofNullable(numRows);
            return this;
        }

        @Override
        @JsonSetter(value="num_rows", nulls=Nulls.SKIP)
        public _FinalStage numRows(Optional<Integer> numRows) {
            this.numRows = numRows;
            return this;
        }

        @Override
        public _FinalStage sizeBytes(Integer sizeBytes) {
            this.sizeBytes = Optional.ofNullable(sizeBytes);
            return this;
        }

        @Override
        @JsonSetter(value="size_bytes", nulls=Nulls.SKIP)
        public _FinalStage sizeBytes(Optional<Integer> sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        @Override
        public _FinalStage index(Integer index) {
            this.index = Optional.ofNullable(index);
            return this;
        }

        @Override
        @JsonSetter(value="index", nulls=Nulls.SKIP)
        public _FinalStage index(Optional<Integer> index) {
            this.index = index;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public DatasetPart build() {
            return new DatasetPart(this.id, this.name, this.url, this.index, this.sizeBytes, this.numRows, this.originalUrl, this.samples, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DatasetPart build();

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage index(Optional<Integer> var1);

        public _FinalStage index(Integer var1);

        public _FinalStage sizeBytes(Optional<Integer> var1);

        public _FinalStage sizeBytes(Integer var1);

        public _FinalStage numRows(Optional<Integer> var1);

        public _FinalStage numRows(Integer var1);

        public _FinalStage originalUrl(Optional<String> var1);

        public _FinalStage originalUrl(String var1);

        public _FinalStage samples(Optional<List<String>> var1);

        public _FinalStage samples(List<String> var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(DatasetPart var1);
    }
}

