/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Document {
    private final Map<String, Object> data;
    private final Optional<String> id;
    private final Map<String, Object> additionalProperties;

    private Document(Map<String, Object> data, Optional<String> id, Map<String, Object> additionalProperties) {
        this.data = data;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="data")
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Document && this.equalTo((Document)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Document other) {
        return this.data.equals(other.data) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, Object> data = new LinkedHashMap<String, Object>();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Document other) {
            this.data(other.getData());
            this.id(other.getId());
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Map<String, Object> data) {
            this.data.clear();
            this.data.putAll(data);
            return this;
        }

        public Builder putAllData(Map<String, Object> data) {
            this.data.putAll(data);
            return this;
        }

        public Builder data(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        public Document build() {
            return new Document(this.data, this.id, this.additionalProperties);
        }
    }
}

