/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.EmbedImage;
import com.cohere.api.types.EmbedText;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class EmbedContent {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private EmbedContent(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static EmbedContent imageUrl(EmbedImage value) {
        return new EmbedContent(new ImageUrlValue(value));
    }

    public static EmbedContent text(EmbedText value) {
        return new EmbedContent(new TextValue(value));
    }

    public boolean isImageUrl() {
        return this.value instanceof ImageUrlValue;
    }

    public boolean isText() {
        return this.value instanceof TextValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<EmbedImage> getImageUrl() {
        if (this.isImageUrl()) {
            return Optional.of(((ImageUrlValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<EmbedText> getText() {
        if (this.isText()) {
            return Optional.of(((TextValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "EmbedContent{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text")
    @JsonIgnoreProperties(value={"type"})
    private static final class TextValue
    implements Value {
        @JsonUnwrapped
        private EmbedText value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextValue() {
        }

        private TextValue(EmbedText value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextValue && this.equalTo((TextValue)other);
        }

        private boolean equalTo(TextValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "EmbedContent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="image_url")
    @JsonIgnoreProperties(value={"type"})
    private static final class ImageUrlValue
    implements Value {
        @JsonUnwrapped
        private EmbedImage value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ImageUrlValue() {
        }

        private ImageUrlValue(EmbedImage value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitImageUrl(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImageUrlValue && this.equalTo((ImageUrlValue)other);
        }

        private boolean equalTo(ImageUrlValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "EmbedContent{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ImageUrlValue.class), @JsonSubTypes.Type(value=TextValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitImageUrl(EmbedImage var1);

        public T visitText(EmbedText var1);

        public T _visitUnknown(Object var1);
    }
}

