/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.EmbedImageUrl;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmbedImage {
    private final Optional<EmbedImageUrl> imageUrl;
    private final Map<String, Object> additionalProperties;

    private EmbedImage(Optional<EmbedImageUrl> imageUrl, Map<String, Object> additionalProperties) {
        this.imageUrl = imageUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_url")
    public Optional<EmbedImageUrl> getImageUrl() {
        return this.imageUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedImage && this.equalTo((EmbedImage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmbedImage other) {
        return this.imageUrl.equals(other.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.imageUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<EmbedImageUrl> imageUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmbedImage other) {
            this.imageUrl(other.getImageUrl());
            return this;
        }

        @JsonSetter(value="image_url", nulls=Nulls.SKIP)
        public Builder imageUrl(Optional<EmbedImageUrl> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder imageUrl(EmbedImageUrl imageUrl) {
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        public EmbedImage build() {
            return new EmbedImage(this.imageUrl, this.additionalProperties);
        }
    }
}

