/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.EmbedContent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmbedInput {
    private final List<EmbedContent> content;
    private final Map<String, Object> additionalProperties;

    private EmbedInput(List<EmbedContent> content, Map<String, Object> additionalProperties) {
        this.content = content;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content")
    public List<EmbedContent> getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedInput && this.equalTo((EmbedInput)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmbedInput other) {
        return this.content.equals(other.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<EmbedContent> content = new ArrayList<EmbedContent>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmbedInput other) {
            this.content(other.getContent());
            return this;
        }

        @JsonSetter(value="content", nulls=Nulls.SKIP)
        public Builder content(List<EmbedContent> content) {
            this.content.clear();
            this.content.addAll(content);
            return this;
        }

        public Builder addContent(EmbedContent content) {
            this.content.add(content);
            return this;
        }

        public Builder addAllContent(List<EmbedContent> content) {
            this.content.addAll(content);
            return this;
        }

        public EmbedInput build() {
            return new EmbedInput(this.content, this.additionalProperties);
        }
    }
}

