/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.EmbedJobStatus;
import com.cohere.api.types.EmbedJobTruncate;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmbedJob {
    private final String jobId;
    private final Optional<String> name;
    private final EmbedJobStatus status;
    private final OffsetDateTime createdAt;
    private final String inputDatasetId;
    private final Optional<String> outputDatasetId;
    private final String model;
    private final EmbedJobTruncate truncate;
    private final Optional<ApiMeta> meta;
    private final Map<String, Object> additionalProperties;

    private EmbedJob(String jobId, Optional<String> name, EmbedJobStatus status, OffsetDateTime createdAt, String inputDatasetId, Optional<String> outputDatasetId, String model, EmbedJobTruncate truncate, Optional<ApiMeta> meta, Map<String, Object> additionalProperties) {
        this.jobId = jobId;
        this.name = name;
        this.status = status;
        this.createdAt = createdAt;
        this.inputDatasetId = inputDatasetId;
        this.outputDatasetId = outputDatasetId;
        this.model = model;
        this.truncate = truncate;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="job_id")
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="status")
    public EmbedJobStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="input_dataset_id")
    public String getInputDatasetId() {
        return this.inputDatasetId;
    }

    @JsonProperty(value="output_dataset_id")
    public Optional<String> getOutputDatasetId() {
        return this.outputDatasetId;
    }

    @JsonProperty(value="model")
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="truncate")
    public EmbedJobTruncate getTruncate() {
        return this.truncate;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmbedJob && this.equalTo((EmbedJob)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmbedJob other) {
        return this.jobId.equals(other.jobId) && this.name.equals(other.name) && this.status.equals((Object)other.status) && this.createdAt.equals(other.createdAt) && this.inputDatasetId.equals(other.inputDatasetId) && this.outputDatasetId.equals(other.outputDatasetId) && this.model.equals(other.model) && this.truncate.equals((Object)other.truncate) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.name, this.status, this.createdAt, this.inputDatasetId, this.outputDatasetId, this.model, this.truncate, this.meta});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static JobIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements JobIdStage,
    StatusStage,
    CreatedAtStage,
    InputDatasetIdStage,
    ModelStage,
    TruncateStage,
    _FinalStage {
        private String jobId;
        private EmbedJobStatus status;
        private OffsetDateTime createdAt;
        private String inputDatasetId;
        private String model;
        private EmbedJobTruncate truncate;
        private Optional<ApiMeta> meta = Optional.empty();
        private Optional<String> outputDatasetId = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EmbedJob other) {
            this.jobId(other.getJobId());
            this.name(other.getName());
            this.status(other.getStatus());
            this.createdAt(other.getCreatedAt());
            this.inputDatasetId(other.getInputDatasetId());
            this.outputDatasetId(other.getOutputDatasetId());
            this.model(other.getModel());
            this.truncate(other.getTruncate());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="job_id")
        public StatusStage jobId(@NotNull String jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public CreatedAtStage status(@NotNull EmbedJobStatus status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public InputDatasetIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="input_dataset_id")
        public ModelStage inputDatasetId(@NotNull String inputDatasetId) {
            this.inputDatasetId = Objects.requireNonNull(inputDatasetId, "inputDatasetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public TruncateStage model(@NotNull String model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="truncate")
        public _FinalStage truncate(@NotNull EmbedJobTruncate truncate) {
            this.truncate = Objects.requireNonNull(truncate, "truncate must not be null");
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage outputDatasetId(String outputDatasetId) {
            this.outputDatasetId = Optional.ofNullable(outputDatasetId);
            return this;
        }

        @Override
        @JsonSetter(value="output_dataset_id", nulls=Nulls.SKIP)
        public _FinalStage outputDatasetId(Optional<String> outputDatasetId) {
            this.outputDatasetId = outputDatasetId;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public EmbedJob build() {
            return new EmbedJob(this.jobId, this.name, this.status, this.createdAt, this.inputDatasetId, this.outputDatasetId, this.model, this.truncate, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EmbedJob build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage outputDatasetId(Optional<String> var1);

        public _FinalStage outputDatasetId(String var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface TruncateStage {
        public _FinalStage truncate(@NotNull EmbedJobTruncate var1);
    }

    public static interface ModelStage {
        public TruncateStage model(@NotNull String var1);
    }

    public static interface InputDatasetIdStage {
        public ModelStage inputDatasetId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public InputDatasetIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public CreatedAtStage status(@NotNull EmbedJobStatus var1);
    }

    public static interface JobIdStage {
        public StatusStage jobId(@NotNull String var1);

        public Builder from(EmbedJob var1);
    }
}

