/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ImageUrl;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImageContent {
    private final ImageUrl imageUrl;
    private final Map<String, Object> additionalProperties;

    private ImageContent(ImageUrl imageUrl, Map<String, Object> additionalProperties) {
        this.imageUrl = imageUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="image_url")
    public ImageUrl getImageUrl() {
        return this.imageUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImageContent && this.equalTo((ImageContent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImageContent other) {
        return this.imageUrl.equals(other.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.imageUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ImageUrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ImageUrlStage,
    _FinalStage {
        private ImageUrl imageUrl;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImageContent other) {
            this.imageUrl(other.getImageUrl());
            return this;
        }

        @Override
        @JsonSetter(value="image_url")
        public _FinalStage imageUrl(@NotNull ImageUrl imageUrl) {
            this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl must not be null");
            return this;
        }

        @Override
        public ImageContent build() {
            return new ImageContent(this.imageUrl, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImageContent build();
    }

    public static interface ImageUrlStage {
        public _FinalStage imageUrl(@NotNull ImageUrl var1);

        public Builder from(ImageContent var1);
    }
}

