/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class JsonResponseFormatV2 {
    private final Optional<Map<String, Object>> jsonSchema;
    private final Map<String, Object> additionalProperties;

    private JsonResponseFormatV2(Optional<Map<String, Object>> jsonSchema, Map<String, Object> additionalProperties) {
        this.jsonSchema = jsonSchema;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="json_schema")
    public Optional<Map<String, Object>> getJsonSchema() {
        return this.jsonSchema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JsonResponseFormatV2 && this.equalTo((JsonResponseFormatV2)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(JsonResponseFormatV2 other) {
        return this.jsonSchema.equals(other.jsonSchema);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSchema);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Map<String, Object>> jsonSchema = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(JsonResponseFormatV2 other) {
            this.jsonSchema(other.getJsonSchema());
            return this;
        }

        @JsonSetter(value="json_schema", nulls=Nulls.SKIP)
        public Builder jsonSchema(Optional<Map<String, Object>> jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        public Builder jsonSchema(Map<String, Object> jsonSchema) {
            this.jsonSchema = Optional.ofNullable(jsonSchema);
            return this;
        }

        public JsonResponseFormatV2 build() {
            return new JsonResponseFormatV2(this.jsonSchema, this.additionalProperties);
        }
    }
}

